/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/**
 * DescribeInstanceEventWindowsRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeInstanceEventWindowsRequestMarshaller implements
        Marshaller<Request<DescribeInstanceEventWindowsRequest>, DescribeInstanceEventWindowsRequest> {

    public Request<DescribeInstanceEventWindowsRequest> marshall(DescribeInstanceEventWindowsRequest describeInstanceEventWindowsRequest) {

        if (describeInstanceEventWindowsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeInstanceEventWindowsRequest> request = new DefaultRequest<DescribeInstanceEventWindowsRequest>(describeInstanceEventWindowsRequest,
                "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceEventWindows");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        com.amazonaws.internal.SdkInternalList<String> describeInstanceEventWindowsRequestInstanceEventWindowIdsList = (com.amazonaws.internal.SdkInternalList<String>) describeInstanceEventWindowsRequest
                .getInstanceEventWindowIds();
        if (!describeInstanceEventWindowsRequestInstanceEventWindowIdsList.isEmpty()
                || !describeInstanceEventWindowsRequestInstanceEventWindowIdsList.isAutoConstruct()) {
            int instanceEventWindowIdsListIndex = 1;

            for (String describeInstanceEventWindowsRequestInstanceEventWindowIdsListValue : describeInstanceEventWindowsRequestInstanceEventWindowIdsList) {
                if (describeInstanceEventWindowsRequestInstanceEventWindowIdsListValue != null) {
                    request.addParameter("InstanceEventWindowId." + instanceEventWindowIdsListIndex,
                            StringUtils.fromString(describeInstanceEventWindowsRequestInstanceEventWindowIdsListValue));
                }
                instanceEventWindowIdsListIndex++;
            }
        }

        com.amazonaws.internal.SdkInternalList<Filter> describeInstanceEventWindowsRequestFiltersList = (com.amazonaws.internal.SdkInternalList<Filter>) describeInstanceEventWindowsRequest
                .getFilters();
        if (!describeInstanceEventWindowsRequestFiltersList.isEmpty() || !describeInstanceEventWindowsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;

            for (Filter describeInstanceEventWindowsRequestFiltersListValue : describeInstanceEventWindowsRequestFiltersList) {

                if (describeInstanceEventWindowsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeInstanceEventWindowsRequestFiltersListValue.getName()));
                }

                com.amazonaws.internal.SdkInternalList<String> filterValuesList = (com.amazonaws.internal.SdkInternalList<String>) describeInstanceEventWindowsRequestFiltersListValue
                        .getValues();
                if (!filterValuesList.isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeInstanceEventWindowsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeInstanceEventWindowsRequest.getMaxResults()));
        }

        if (describeInstanceEventWindowsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeInstanceEventWindowsRequest.getNextToken()));
        }

        return request;
    }

}
