/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PurchaseCapacityBlockRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PurchaseCapacityBlockRequestMarshaller
implements Marshaller<Request<PurchaseCapacityBlockRequest>, PurchaseCapacityBlockRequest> {
    public Request<PurchaseCapacityBlockRequest> marshall(PurchaseCapacityBlockRequest purchaseCapacityBlockRequest) {
        if (purchaseCapacityBlockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purchaseCapacityBlockRequest, "AmazonEC2");
        request.addParameter("Action", "PurchaseCapacityBlock");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList purchaseCapacityBlockRequestTagSpecificationsList = (SdkInternalList)purchaseCapacityBlockRequest.getTagSpecifications();
        if (!purchaseCapacityBlockRequestTagSpecificationsList.isEmpty() || !purchaseCapacityBlockRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification purchaseCapacityBlockRequestTagSpecificationsListValue : purchaseCapacityBlockRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (purchaseCapacityBlockRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)purchaseCapacityBlockRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)purchaseCapacityBlockRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (purchaseCapacityBlockRequest.getCapacityBlockOfferingId() != null) {
            request.addParameter("CapacityBlockOfferingId", StringUtils.fromString((String)purchaseCapacityBlockRequest.getCapacityBlockOfferingId()));
        }
        if (purchaseCapacityBlockRequest.getInstancePlatform() != null) {
            request.addParameter("InstancePlatform", StringUtils.fromString((String)purchaseCapacityBlockRequest.getInstancePlatform()));
        }
        return request;
    }
}

