/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeObjectsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String pipelineId;
    private SdkInternalList<String> objectIds;
    private Boolean evaluateExpressions;
    private String marker;

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public DescribeObjectsRequest withPipelineId(String pipelineId) {
        this.setPipelineId(pipelineId);
        return this;
    }

    public List<String> getObjectIds() {
        if (this.objectIds == null) {
            this.objectIds = new SdkInternalList();
        }
        return this.objectIds;
    }

    public void setObjectIds(Collection<String> objectIds) {
        if (objectIds == null) {
            this.objectIds = null;
            return;
        }
        this.objectIds = new SdkInternalList(objectIds);
    }

    public DescribeObjectsRequest withObjectIds(String ... objectIds) {
        if (this.objectIds == null) {
            this.setObjectIds((Collection<String>)new SdkInternalList(objectIds.length));
        }
        for (String ele : objectIds) {
            this.objectIds.add((Object)ele);
        }
        return this;
    }

    public DescribeObjectsRequest withObjectIds(Collection<String> objectIds) {
        this.setObjectIds(objectIds);
        return this;
    }

    public void setEvaluateExpressions(Boolean evaluateExpressions) {
        this.evaluateExpressions = evaluateExpressions;
    }

    public Boolean getEvaluateExpressions() {
        return this.evaluateExpressions;
    }

    public DescribeObjectsRequest withEvaluateExpressions(Boolean evaluateExpressions) {
        this.setEvaluateExpressions(evaluateExpressions);
        return this;
    }

    public Boolean isEvaluateExpressions() {
        return this.evaluateExpressions;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeObjectsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: ").append(this.getPipelineId()).append(",");
        }
        if (this.getObjectIds() != null) {
            sb.append("ObjectIds: ").append(this.getObjectIds()).append(",");
        }
        if (this.getEvaluateExpressions() != null) {
            sb.append("EvaluateExpressions: ").append(this.getEvaluateExpressions()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectsRequest)) {
            return false;
        }
        DescribeObjectsRequest other = (DescribeObjectsRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getObjectIds() == null ^ this.getObjectIds() == null) {
            return false;
        }
        if (other.getObjectIds() != null && !other.getObjectIds().equals(this.getObjectIds())) {
            return false;
        }
        if (other.getEvaluateExpressions() == null ^ this.getEvaluateExpressions() == null) {
            return false;
        }
        if (other.getEvaluateExpressions() != null && !other.getEvaluateExpressions().equals(this.getEvaluateExpressions())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getObjectIds() == null ? 0 : this.getObjectIds().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluateExpressions() == null ? 0 : this.getEvaluateExpressions().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public DescribeObjectsRequest clone() {
        return (DescribeObjectsRequest)super.clone();
    }
}

