/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.DBStorageConfiguration;
import com.amazonaws.services.computeoptimizer.model.Idle;
import com.amazonaws.services.computeoptimizer.model.RDSDBInstanceRecommendationOption;
import com.amazonaws.services.computeoptimizer.model.RDSDBStorageRecommendationOption;
import com.amazonaws.services.computeoptimizer.model.RDSDBUtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.RDSEffectiveRecommendationPreferences;
import com.amazonaws.services.computeoptimizer.model.RDSInstanceFinding;
import com.amazonaws.services.computeoptimizer.model.RDSInstanceFindingReasonCode;
import com.amazonaws.services.computeoptimizer.model.RDSStorageFinding;
import com.amazonaws.services.computeoptimizer.model.RDSStorageFindingReasonCode;
import com.amazonaws.services.computeoptimizer.model.Tag;
import com.amazonaws.services.computeoptimizer.model.transform.RDSDBRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RDSDBRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceArn;
    private String accountId;
    private String engine;
    private String engineVersion;
    private String currentDBInstanceClass;
    private DBStorageConfiguration currentStorageConfiguration;
    private String idle;
    private String instanceFinding;
    private String storageFinding;
    private List<String> instanceFindingReasonCodes;
    private List<String> storageFindingReasonCodes;
    private List<RDSDBInstanceRecommendationOption> instanceRecommendationOptions;
    private List<RDSDBStorageRecommendationOption> storageRecommendationOptions;
    private List<RDSDBUtilizationMetric> utilizationMetrics;
    private RDSEffectiveRecommendationPreferences effectiveRecommendationPreferences;
    private Double lookbackPeriodInDays;
    private Date lastRefreshTimestamp;
    private List<Tag> tags;

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public RDSDBRecommendation withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public RDSDBRecommendation withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public RDSDBRecommendation withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public RDSDBRecommendation withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setCurrentDBInstanceClass(String currentDBInstanceClass) {
        this.currentDBInstanceClass = currentDBInstanceClass;
    }

    public String getCurrentDBInstanceClass() {
        return this.currentDBInstanceClass;
    }

    public RDSDBRecommendation withCurrentDBInstanceClass(String currentDBInstanceClass) {
        this.setCurrentDBInstanceClass(currentDBInstanceClass);
        return this;
    }

    public void setCurrentStorageConfiguration(DBStorageConfiguration currentStorageConfiguration) {
        this.currentStorageConfiguration = currentStorageConfiguration;
    }

    public DBStorageConfiguration getCurrentStorageConfiguration() {
        return this.currentStorageConfiguration;
    }

    public RDSDBRecommendation withCurrentStorageConfiguration(DBStorageConfiguration currentStorageConfiguration) {
        this.setCurrentStorageConfiguration(currentStorageConfiguration);
        return this;
    }

    public void setIdle(String idle) {
        this.idle = idle;
    }

    public String getIdle() {
        return this.idle;
    }

    public RDSDBRecommendation withIdle(String idle) {
        this.setIdle(idle);
        return this;
    }

    public RDSDBRecommendation withIdle(Idle idle) {
        this.idle = idle.toString();
        return this;
    }

    public void setInstanceFinding(String instanceFinding) {
        this.instanceFinding = instanceFinding;
    }

    public String getInstanceFinding() {
        return this.instanceFinding;
    }

    public RDSDBRecommendation withInstanceFinding(String instanceFinding) {
        this.setInstanceFinding(instanceFinding);
        return this;
    }

    public RDSDBRecommendation withInstanceFinding(RDSInstanceFinding instanceFinding) {
        this.instanceFinding = instanceFinding.toString();
        return this;
    }

    public void setStorageFinding(String storageFinding) {
        this.storageFinding = storageFinding;
    }

    public String getStorageFinding() {
        return this.storageFinding;
    }

    public RDSDBRecommendation withStorageFinding(String storageFinding) {
        this.setStorageFinding(storageFinding);
        return this;
    }

    public RDSDBRecommendation withStorageFinding(RDSStorageFinding storageFinding) {
        this.storageFinding = storageFinding.toString();
        return this;
    }

    public List<String> getInstanceFindingReasonCodes() {
        return this.instanceFindingReasonCodes;
    }

    public void setInstanceFindingReasonCodes(Collection<String> instanceFindingReasonCodes) {
        if (instanceFindingReasonCodes == null) {
            this.instanceFindingReasonCodes = null;
            return;
        }
        this.instanceFindingReasonCodes = new ArrayList<String>(instanceFindingReasonCodes);
    }

    public RDSDBRecommendation withInstanceFindingReasonCodes(String ... instanceFindingReasonCodes) {
        if (this.instanceFindingReasonCodes == null) {
            this.setInstanceFindingReasonCodes(new ArrayList<String>(instanceFindingReasonCodes.length));
        }
        for (String ele : instanceFindingReasonCodes) {
            this.instanceFindingReasonCodes.add(ele);
        }
        return this;
    }

    public RDSDBRecommendation withInstanceFindingReasonCodes(Collection<String> instanceFindingReasonCodes) {
        this.setInstanceFindingReasonCodes(instanceFindingReasonCodes);
        return this;
    }

    public RDSDBRecommendation withInstanceFindingReasonCodes(RDSInstanceFindingReasonCode ... instanceFindingReasonCodes) {
        ArrayList<String> instanceFindingReasonCodesCopy = new ArrayList<String>(instanceFindingReasonCodes.length);
        for (RDSInstanceFindingReasonCode value : instanceFindingReasonCodes) {
            instanceFindingReasonCodesCopy.add(value.toString());
        }
        if (this.getInstanceFindingReasonCodes() == null) {
            this.setInstanceFindingReasonCodes(instanceFindingReasonCodesCopy);
        } else {
            this.getInstanceFindingReasonCodes().addAll(instanceFindingReasonCodesCopy);
        }
        return this;
    }

    public List<String> getStorageFindingReasonCodes() {
        return this.storageFindingReasonCodes;
    }

    public void setStorageFindingReasonCodes(Collection<String> storageFindingReasonCodes) {
        if (storageFindingReasonCodes == null) {
            this.storageFindingReasonCodes = null;
            return;
        }
        this.storageFindingReasonCodes = new ArrayList<String>(storageFindingReasonCodes);
    }

    public RDSDBRecommendation withStorageFindingReasonCodes(String ... storageFindingReasonCodes) {
        if (this.storageFindingReasonCodes == null) {
            this.setStorageFindingReasonCodes(new ArrayList<String>(storageFindingReasonCodes.length));
        }
        for (String ele : storageFindingReasonCodes) {
            this.storageFindingReasonCodes.add(ele);
        }
        return this;
    }

    public RDSDBRecommendation withStorageFindingReasonCodes(Collection<String> storageFindingReasonCodes) {
        this.setStorageFindingReasonCodes(storageFindingReasonCodes);
        return this;
    }

    public RDSDBRecommendation withStorageFindingReasonCodes(RDSStorageFindingReasonCode ... storageFindingReasonCodes) {
        ArrayList<String> storageFindingReasonCodesCopy = new ArrayList<String>(storageFindingReasonCodes.length);
        for (RDSStorageFindingReasonCode value : storageFindingReasonCodes) {
            storageFindingReasonCodesCopy.add(value.toString());
        }
        if (this.getStorageFindingReasonCodes() == null) {
            this.setStorageFindingReasonCodes(storageFindingReasonCodesCopy);
        } else {
            this.getStorageFindingReasonCodes().addAll(storageFindingReasonCodesCopy);
        }
        return this;
    }

    public List<RDSDBInstanceRecommendationOption> getInstanceRecommendationOptions() {
        return this.instanceRecommendationOptions;
    }

    public void setInstanceRecommendationOptions(Collection<RDSDBInstanceRecommendationOption> instanceRecommendationOptions) {
        if (instanceRecommendationOptions == null) {
            this.instanceRecommendationOptions = null;
            return;
        }
        this.instanceRecommendationOptions = new ArrayList<RDSDBInstanceRecommendationOption>(instanceRecommendationOptions);
    }

    public RDSDBRecommendation withInstanceRecommendationOptions(RDSDBInstanceRecommendationOption ... instanceRecommendationOptions) {
        if (this.instanceRecommendationOptions == null) {
            this.setInstanceRecommendationOptions(new ArrayList<RDSDBInstanceRecommendationOption>(instanceRecommendationOptions.length));
        }
        for (RDSDBInstanceRecommendationOption ele : instanceRecommendationOptions) {
            this.instanceRecommendationOptions.add(ele);
        }
        return this;
    }

    public RDSDBRecommendation withInstanceRecommendationOptions(Collection<RDSDBInstanceRecommendationOption> instanceRecommendationOptions) {
        this.setInstanceRecommendationOptions(instanceRecommendationOptions);
        return this;
    }

    public List<RDSDBStorageRecommendationOption> getStorageRecommendationOptions() {
        return this.storageRecommendationOptions;
    }

    public void setStorageRecommendationOptions(Collection<RDSDBStorageRecommendationOption> storageRecommendationOptions) {
        if (storageRecommendationOptions == null) {
            this.storageRecommendationOptions = null;
            return;
        }
        this.storageRecommendationOptions = new ArrayList<RDSDBStorageRecommendationOption>(storageRecommendationOptions);
    }

    public RDSDBRecommendation withStorageRecommendationOptions(RDSDBStorageRecommendationOption ... storageRecommendationOptions) {
        if (this.storageRecommendationOptions == null) {
            this.setStorageRecommendationOptions(new ArrayList<RDSDBStorageRecommendationOption>(storageRecommendationOptions.length));
        }
        for (RDSDBStorageRecommendationOption ele : storageRecommendationOptions) {
            this.storageRecommendationOptions.add(ele);
        }
        return this;
    }

    public RDSDBRecommendation withStorageRecommendationOptions(Collection<RDSDBStorageRecommendationOption> storageRecommendationOptions) {
        this.setStorageRecommendationOptions(storageRecommendationOptions);
        return this;
    }

    public List<RDSDBUtilizationMetric> getUtilizationMetrics() {
        return this.utilizationMetrics;
    }

    public void setUtilizationMetrics(Collection<RDSDBUtilizationMetric> utilizationMetrics) {
        if (utilizationMetrics == null) {
            this.utilizationMetrics = null;
            return;
        }
        this.utilizationMetrics = new ArrayList<RDSDBUtilizationMetric>(utilizationMetrics);
    }

    public RDSDBRecommendation withUtilizationMetrics(RDSDBUtilizationMetric ... utilizationMetrics) {
        if (this.utilizationMetrics == null) {
            this.setUtilizationMetrics(new ArrayList<RDSDBUtilizationMetric>(utilizationMetrics.length));
        }
        for (RDSDBUtilizationMetric ele : utilizationMetrics) {
            this.utilizationMetrics.add(ele);
        }
        return this;
    }

    public RDSDBRecommendation withUtilizationMetrics(Collection<RDSDBUtilizationMetric> utilizationMetrics) {
        this.setUtilizationMetrics(utilizationMetrics);
        return this;
    }

    public void setEffectiveRecommendationPreferences(RDSEffectiveRecommendationPreferences effectiveRecommendationPreferences) {
        this.effectiveRecommendationPreferences = effectiveRecommendationPreferences;
    }

    public RDSEffectiveRecommendationPreferences getEffectiveRecommendationPreferences() {
        return this.effectiveRecommendationPreferences;
    }

    public RDSDBRecommendation withEffectiveRecommendationPreferences(RDSEffectiveRecommendationPreferences effectiveRecommendationPreferences) {
        this.setEffectiveRecommendationPreferences(effectiveRecommendationPreferences);
        return this;
    }

    public void setLookbackPeriodInDays(Double lookbackPeriodInDays) {
        this.lookbackPeriodInDays = lookbackPeriodInDays;
    }

    public Double getLookbackPeriodInDays() {
        return this.lookbackPeriodInDays;
    }

    public RDSDBRecommendation withLookbackPeriodInDays(Double lookbackPeriodInDays) {
        this.setLookbackPeriodInDays(lookbackPeriodInDays);
        return this;
    }

    public void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.lastRefreshTimestamp = lastRefreshTimestamp;
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public RDSDBRecommendation withLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.setLastRefreshTimestamp(lastRefreshTimestamp);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public RDSDBRecommendation withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public RDSDBRecommendation withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getCurrentDBInstanceClass() != null) {
            sb.append("CurrentDBInstanceClass: ").append(this.getCurrentDBInstanceClass()).append(",");
        }
        if (this.getCurrentStorageConfiguration() != null) {
            sb.append("CurrentStorageConfiguration: ").append(this.getCurrentStorageConfiguration()).append(",");
        }
        if (this.getIdle() != null) {
            sb.append("Idle: ").append(this.getIdle()).append(",");
        }
        if (this.getInstanceFinding() != null) {
            sb.append("InstanceFinding: ").append(this.getInstanceFinding()).append(",");
        }
        if (this.getStorageFinding() != null) {
            sb.append("StorageFinding: ").append(this.getStorageFinding()).append(",");
        }
        if (this.getInstanceFindingReasonCodes() != null) {
            sb.append("InstanceFindingReasonCodes: ").append(this.getInstanceFindingReasonCodes()).append(",");
        }
        if (this.getStorageFindingReasonCodes() != null) {
            sb.append("StorageFindingReasonCodes: ").append(this.getStorageFindingReasonCodes()).append(",");
        }
        if (this.getInstanceRecommendationOptions() != null) {
            sb.append("InstanceRecommendationOptions: ").append(this.getInstanceRecommendationOptions()).append(",");
        }
        if (this.getStorageRecommendationOptions() != null) {
            sb.append("StorageRecommendationOptions: ").append(this.getStorageRecommendationOptions()).append(",");
        }
        if (this.getUtilizationMetrics() != null) {
            sb.append("UtilizationMetrics: ").append(this.getUtilizationMetrics()).append(",");
        }
        if (this.getEffectiveRecommendationPreferences() != null) {
            sb.append("EffectiveRecommendationPreferences: ").append(this.getEffectiveRecommendationPreferences()).append(",");
        }
        if (this.getLookbackPeriodInDays() != null) {
            sb.append("LookbackPeriodInDays: ").append(this.getLookbackPeriodInDays()).append(",");
        }
        if (this.getLastRefreshTimestamp() != null) {
            sb.append("LastRefreshTimestamp: ").append(this.getLastRefreshTimestamp()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDBRecommendation)) {
            return false;
        }
        RDSDBRecommendation other = (RDSDBRecommendation)obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getCurrentDBInstanceClass() == null ^ this.getCurrentDBInstanceClass() == null) {
            return false;
        }
        if (other.getCurrentDBInstanceClass() != null && !other.getCurrentDBInstanceClass().equals(this.getCurrentDBInstanceClass())) {
            return false;
        }
        if (other.getCurrentStorageConfiguration() == null ^ this.getCurrentStorageConfiguration() == null) {
            return false;
        }
        if (other.getCurrentStorageConfiguration() != null && !other.getCurrentStorageConfiguration().equals(this.getCurrentStorageConfiguration())) {
            return false;
        }
        if (other.getIdle() == null ^ this.getIdle() == null) {
            return false;
        }
        if (other.getIdle() != null && !other.getIdle().equals(this.getIdle())) {
            return false;
        }
        if (other.getInstanceFinding() == null ^ this.getInstanceFinding() == null) {
            return false;
        }
        if (other.getInstanceFinding() != null && !other.getInstanceFinding().equals(this.getInstanceFinding())) {
            return false;
        }
        if (other.getStorageFinding() == null ^ this.getStorageFinding() == null) {
            return false;
        }
        if (other.getStorageFinding() != null && !other.getStorageFinding().equals(this.getStorageFinding())) {
            return false;
        }
        if (other.getInstanceFindingReasonCodes() == null ^ this.getInstanceFindingReasonCodes() == null) {
            return false;
        }
        if (other.getInstanceFindingReasonCodes() != null && !other.getInstanceFindingReasonCodes().equals(this.getInstanceFindingReasonCodes())) {
            return false;
        }
        if (other.getStorageFindingReasonCodes() == null ^ this.getStorageFindingReasonCodes() == null) {
            return false;
        }
        if (other.getStorageFindingReasonCodes() != null && !other.getStorageFindingReasonCodes().equals(this.getStorageFindingReasonCodes())) {
            return false;
        }
        if (other.getInstanceRecommendationOptions() == null ^ this.getInstanceRecommendationOptions() == null) {
            return false;
        }
        if (other.getInstanceRecommendationOptions() != null && !other.getInstanceRecommendationOptions().equals(this.getInstanceRecommendationOptions())) {
            return false;
        }
        if (other.getStorageRecommendationOptions() == null ^ this.getStorageRecommendationOptions() == null) {
            return false;
        }
        if (other.getStorageRecommendationOptions() != null && !other.getStorageRecommendationOptions().equals(this.getStorageRecommendationOptions())) {
            return false;
        }
        if (other.getUtilizationMetrics() == null ^ this.getUtilizationMetrics() == null) {
            return false;
        }
        if (other.getUtilizationMetrics() != null && !other.getUtilizationMetrics().equals(this.getUtilizationMetrics())) {
            return false;
        }
        if (other.getEffectiveRecommendationPreferences() == null ^ this.getEffectiveRecommendationPreferences() == null) {
            return false;
        }
        if (other.getEffectiveRecommendationPreferences() != null && !other.getEffectiveRecommendationPreferences().equals(this.getEffectiveRecommendationPreferences())) {
            return false;
        }
        if (other.getLookbackPeriodInDays() == null ^ this.getLookbackPeriodInDays() == null) {
            return false;
        }
        if (other.getLookbackPeriodInDays() != null && !other.getLookbackPeriodInDays().equals(this.getLookbackPeriodInDays())) {
            return false;
        }
        if (other.getLastRefreshTimestamp() == null ^ this.getLastRefreshTimestamp() == null) {
            return false;
        }
        if (other.getLastRefreshTimestamp() != null && !other.getLastRefreshTimestamp().equals(this.getLastRefreshTimestamp())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentDBInstanceClass() == null ? 0 : this.getCurrentDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentStorageConfiguration() == null ? 0 : this.getCurrentStorageConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getIdle() == null ? 0 : this.getIdle().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFinding() == null ? 0 : this.getInstanceFinding().hashCode());
        hashCode = 31 * hashCode + (this.getStorageFinding() == null ? 0 : this.getStorageFinding().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFindingReasonCodes() == null ? 0 : this.getInstanceFindingReasonCodes().hashCode());
        hashCode = 31 * hashCode + (this.getStorageFindingReasonCodes() == null ? 0 : this.getStorageFindingReasonCodes().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceRecommendationOptions() == null ? 0 : this.getInstanceRecommendationOptions().hashCode());
        hashCode = 31 * hashCode + (this.getStorageRecommendationOptions() == null ? 0 : this.getStorageRecommendationOptions().hashCode());
        hashCode = 31 * hashCode + (this.getUtilizationMetrics() == null ? 0 : this.getUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getEffectiveRecommendationPreferences() == null ? 0 : this.getEffectiveRecommendationPreferences().hashCode());
        hashCode = 31 * hashCode + (this.getLookbackPeriodInDays() == null ? 0 : this.getLookbackPeriodInDays().hashCode());
        hashCode = 31 * hashCode + (this.getLastRefreshTimestamp() == null ? 0 : this.getLastRefreshTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public RDSDBRecommendation clone() {
        try {
            return (RDSDBRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDBRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

