/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizerAsync;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizerAsyncClientBuilder;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizerClient;
import com.amazonaws.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest;
import com.amazonaws.services.computeoptimizer.model.DeleteRecommendationPreferencesResult;
import com.amazonaws.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest;
import com.amazonaws.services.computeoptimizer.model.DescribeRecommendationExportJobsResult;
import com.amazonaws.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportEBSVolumeRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportEBSVolumeRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportEC2InstanceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportEC2InstanceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportECSServiceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportECSServiceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEBSVolumeRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEBSVolumeRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEC2InstanceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEC2InstanceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEC2RecommendationProjectedMetricsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEC2RecommendationProjectedMetricsResult;
import com.amazonaws.services.computeoptimizer.model.GetECSServiceRecommendationProjectedMetricsRequest;
import com.amazonaws.services.computeoptimizer.model.GetECSServiceRecommendationProjectedMetricsResult;
import com.amazonaws.services.computeoptimizer.model.GetECSServiceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetECSServiceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest;
import com.amazonaws.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResult;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusRequest;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusResult;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResult;
import com.amazonaws.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationPreferencesRequest;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationPreferencesResult;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationSummariesRequest;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationSummariesResult;
import com.amazonaws.services.computeoptimizer.model.PutRecommendationPreferencesRequest;
import com.amazonaws.services.computeoptimizer.model.PutRecommendationPreferencesResult;
import com.amazonaws.services.computeoptimizer.model.UpdateEnrollmentStatusRequest;
import com.amazonaws.services.computeoptimizer.model.UpdateEnrollmentStatusResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSComputeOptimizerAsyncClient
extends AWSComputeOptimizerClient
implements AWSComputeOptimizerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSComputeOptimizerAsyncClientBuilder asyncBuilder() {
        return AWSComputeOptimizerAsyncClientBuilder.standard();
    }

    AWSComputeOptimizerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSComputeOptimizerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteRecommendationPreferencesResult> deleteRecommendationPreferencesAsync(DeleteRecommendationPreferencesRequest request) {
        return this.deleteRecommendationPreferencesAsync(request, null);
    }

    @Override
    public Future<DeleteRecommendationPreferencesResult> deleteRecommendationPreferencesAsync(DeleteRecommendationPreferencesRequest request, final AsyncHandler<DeleteRecommendationPreferencesRequest, DeleteRecommendationPreferencesResult> asyncHandler) {
        final DeleteRecommendationPreferencesRequest finalRequest = (DeleteRecommendationPreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRecommendationPreferencesResult>(){

            @Override
            public DeleteRecommendationPreferencesResult call() throws Exception {
                DeleteRecommendationPreferencesResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeDeleteRecommendationPreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRecommendationExportJobsResult> describeRecommendationExportJobsAsync(DescribeRecommendationExportJobsRequest request) {
        return this.describeRecommendationExportJobsAsync(request, null);
    }

    @Override
    public Future<DescribeRecommendationExportJobsResult> describeRecommendationExportJobsAsync(DescribeRecommendationExportJobsRequest request, final AsyncHandler<DescribeRecommendationExportJobsRequest, DescribeRecommendationExportJobsResult> asyncHandler) {
        final DescribeRecommendationExportJobsRequest finalRequest = (DescribeRecommendationExportJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRecommendationExportJobsResult>(){

            @Override
            public DescribeRecommendationExportJobsResult call() throws Exception {
                DescribeRecommendationExportJobsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeDescribeRecommendationExportJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportAutoScalingGroupRecommendationsResult> exportAutoScalingGroupRecommendationsAsync(ExportAutoScalingGroupRecommendationsRequest request) {
        return this.exportAutoScalingGroupRecommendationsAsync(request, null);
    }

    @Override
    public Future<ExportAutoScalingGroupRecommendationsResult> exportAutoScalingGroupRecommendationsAsync(ExportAutoScalingGroupRecommendationsRequest request, final AsyncHandler<ExportAutoScalingGroupRecommendationsRequest, ExportAutoScalingGroupRecommendationsResult> asyncHandler) {
        final ExportAutoScalingGroupRecommendationsRequest finalRequest = (ExportAutoScalingGroupRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportAutoScalingGroupRecommendationsResult>(){

            @Override
            public ExportAutoScalingGroupRecommendationsResult call() throws Exception {
                ExportAutoScalingGroupRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeExportAutoScalingGroupRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportEBSVolumeRecommendationsResult> exportEBSVolumeRecommendationsAsync(ExportEBSVolumeRecommendationsRequest request) {
        return this.exportEBSVolumeRecommendationsAsync(request, null);
    }

    @Override
    public Future<ExportEBSVolumeRecommendationsResult> exportEBSVolumeRecommendationsAsync(ExportEBSVolumeRecommendationsRequest request, final AsyncHandler<ExportEBSVolumeRecommendationsRequest, ExportEBSVolumeRecommendationsResult> asyncHandler) {
        final ExportEBSVolumeRecommendationsRequest finalRequest = (ExportEBSVolumeRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportEBSVolumeRecommendationsResult>(){

            @Override
            public ExportEBSVolumeRecommendationsResult call() throws Exception {
                ExportEBSVolumeRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeExportEBSVolumeRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportEC2InstanceRecommendationsResult> exportEC2InstanceRecommendationsAsync(ExportEC2InstanceRecommendationsRequest request) {
        return this.exportEC2InstanceRecommendationsAsync(request, null);
    }

    @Override
    public Future<ExportEC2InstanceRecommendationsResult> exportEC2InstanceRecommendationsAsync(ExportEC2InstanceRecommendationsRequest request, final AsyncHandler<ExportEC2InstanceRecommendationsRequest, ExportEC2InstanceRecommendationsResult> asyncHandler) {
        final ExportEC2InstanceRecommendationsRequest finalRequest = (ExportEC2InstanceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportEC2InstanceRecommendationsResult>(){

            @Override
            public ExportEC2InstanceRecommendationsResult call() throws Exception {
                ExportEC2InstanceRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeExportEC2InstanceRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportECSServiceRecommendationsResult> exportECSServiceRecommendationsAsync(ExportECSServiceRecommendationsRequest request) {
        return this.exportECSServiceRecommendationsAsync(request, null);
    }

    @Override
    public Future<ExportECSServiceRecommendationsResult> exportECSServiceRecommendationsAsync(ExportECSServiceRecommendationsRequest request, final AsyncHandler<ExportECSServiceRecommendationsRequest, ExportECSServiceRecommendationsResult> asyncHandler) {
        final ExportECSServiceRecommendationsRequest finalRequest = (ExportECSServiceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportECSServiceRecommendationsResult>(){

            @Override
            public ExportECSServiceRecommendationsResult call() throws Exception {
                ExportECSServiceRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeExportECSServiceRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportLambdaFunctionRecommendationsResult> exportLambdaFunctionRecommendationsAsync(ExportLambdaFunctionRecommendationsRequest request) {
        return this.exportLambdaFunctionRecommendationsAsync(request, null);
    }

    @Override
    public Future<ExportLambdaFunctionRecommendationsResult> exportLambdaFunctionRecommendationsAsync(ExportLambdaFunctionRecommendationsRequest request, final AsyncHandler<ExportLambdaFunctionRecommendationsRequest, ExportLambdaFunctionRecommendationsResult> asyncHandler) {
        final ExportLambdaFunctionRecommendationsRequest finalRequest = (ExportLambdaFunctionRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportLambdaFunctionRecommendationsResult>(){

            @Override
            public ExportLambdaFunctionRecommendationsResult call() throws Exception {
                ExportLambdaFunctionRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeExportLambdaFunctionRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAutoScalingGroupRecommendationsResult> getAutoScalingGroupRecommendationsAsync(GetAutoScalingGroupRecommendationsRequest request) {
        return this.getAutoScalingGroupRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetAutoScalingGroupRecommendationsResult> getAutoScalingGroupRecommendationsAsync(GetAutoScalingGroupRecommendationsRequest request, final AsyncHandler<GetAutoScalingGroupRecommendationsRequest, GetAutoScalingGroupRecommendationsResult> asyncHandler) {
        final GetAutoScalingGroupRecommendationsRequest finalRequest = (GetAutoScalingGroupRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAutoScalingGroupRecommendationsResult>(){

            @Override
            public GetAutoScalingGroupRecommendationsResult call() throws Exception {
                GetAutoScalingGroupRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetAutoScalingGroupRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEBSVolumeRecommendationsResult> getEBSVolumeRecommendationsAsync(GetEBSVolumeRecommendationsRequest request) {
        return this.getEBSVolumeRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetEBSVolumeRecommendationsResult> getEBSVolumeRecommendationsAsync(GetEBSVolumeRecommendationsRequest request, final AsyncHandler<GetEBSVolumeRecommendationsRequest, GetEBSVolumeRecommendationsResult> asyncHandler) {
        final GetEBSVolumeRecommendationsRequest finalRequest = (GetEBSVolumeRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEBSVolumeRecommendationsResult>(){

            @Override
            public GetEBSVolumeRecommendationsResult call() throws Exception {
                GetEBSVolumeRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetEBSVolumeRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEC2InstanceRecommendationsResult> getEC2InstanceRecommendationsAsync(GetEC2InstanceRecommendationsRequest request) {
        return this.getEC2InstanceRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetEC2InstanceRecommendationsResult> getEC2InstanceRecommendationsAsync(GetEC2InstanceRecommendationsRequest request, final AsyncHandler<GetEC2InstanceRecommendationsRequest, GetEC2InstanceRecommendationsResult> asyncHandler) {
        final GetEC2InstanceRecommendationsRequest finalRequest = (GetEC2InstanceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEC2InstanceRecommendationsResult>(){

            @Override
            public GetEC2InstanceRecommendationsResult call() throws Exception {
                GetEC2InstanceRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetEC2InstanceRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEC2RecommendationProjectedMetricsResult> getEC2RecommendationProjectedMetricsAsync(GetEC2RecommendationProjectedMetricsRequest request) {
        return this.getEC2RecommendationProjectedMetricsAsync(request, null);
    }

    @Override
    public Future<GetEC2RecommendationProjectedMetricsResult> getEC2RecommendationProjectedMetricsAsync(GetEC2RecommendationProjectedMetricsRequest request, final AsyncHandler<GetEC2RecommendationProjectedMetricsRequest, GetEC2RecommendationProjectedMetricsResult> asyncHandler) {
        final GetEC2RecommendationProjectedMetricsRequest finalRequest = (GetEC2RecommendationProjectedMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEC2RecommendationProjectedMetricsResult>(){

            @Override
            public GetEC2RecommendationProjectedMetricsResult call() throws Exception {
                GetEC2RecommendationProjectedMetricsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetEC2RecommendationProjectedMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetECSServiceRecommendationProjectedMetricsResult> getECSServiceRecommendationProjectedMetricsAsync(GetECSServiceRecommendationProjectedMetricsRequest request) {
        return this.getECSServiceRecommendationProjectedMetricsAsync(request, null);
    }

    @Override
    public Future<GetECSServiceRecommendationProjectedMetricsResult> getECSServiceRecommendationProjectedMetricsAsync(GetECSServiceRecommendationProjectedMetricsRequest request, final AsyncHandler<GetECSServiceRecommendationProjectedMetricsRequest, GetECSServiceRecommendationProjectedMetricsResult> asyncHandler) {
        final GetECSServiceRecommendationProjectedMetricsRequest finalRequest = (GetECSServiceRecommendationProjectedMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetECSServiceRecommendationProjectedMetricsResult>(){

            @Override
            public GetECSServiceRecommendationProjectedMetricsResult call() throws Exception {
                GetECSServiceRecommendationProjectedMetricsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetECSServiceRecommendationProjectedMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetECSServiceRecommendationsResult> getECSServiceRecommendationsAsync(GetECSServiceRecommendationsRequest request) {
        return this.getECSServiceRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetECSServiceRecommendationsResult> getECSServiceRecommendationsAsync(GetECSServiceRecommendationsRequest request, final AsyncHandler<GetECSServiceRecommendationsRequest, GetECSServiceRecommendationsResult> asyncHandler) {
        final GetECSServiceRecommendationsRequest finalRequest = (GetECSServiceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetECSServiceRecommendationsResult>(){

            @Override
            public GetECSServiceRecommendationsResult call() throws Exception {
                GetECSServiceRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetECSServiceRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEffectiveRecommendationPreferencesResult> getEffectiveRecommendationPreferencesAsync(GetEffectiveRecommendationPreferencesRequest request) {
        return this.getEffectiveRecommendationPreferencesAsync(request, null);
    }

    @Override
    public Future<GetEffectiveRecommendationPreferencesResult> getEffectiveRecommendationPreferencesAsync(GetEffectiveRecommendationPreferencesRequest request, final AsyncHandler<GetEffectiveRecommendationPreferencesRequest, GetEffectiveRecommendationPreferencesResult> asyncHandler) {
        final GetEffectiveRecommendationPreferencesRequest finalRequest = (GetEffectiveRecommendationPreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEffectiveRecommendationPreferencesResult>(){

            @Override
            public GetEffectiveRecommendationPreferencesResult call() throws Exception {
                GetEffectiveRecommendationPreferencesResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetEffectiveRecommendationPreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEnrollmentStatusResult> getEnrollmentStatusAsync(GetEnrollmentStatusRequest request) {
        return this.getEnrollmentStatusAsync(request, null);
    }

    @Override
    public Future<GetEnrollmentStatusResult> getEnrollmentStatusAsync(GetEnrollmentStatusRequest request, final AsyncHandler<GetEnrollmentStatusRequest, GetEnrollmentStatusResult> asyncHandler) {
        final GetEnrollmentStatusRequest finalRequest = (GetEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEnrollmentStatusResult>(){

            @Override
            public GetEnrollmentStatusResult call() throws Exception {
                GetEnrollmentStatusResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetEnrollmentStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEnrollmentStatusesForOrganizationResult> getEnrollmentStatusesForOrganizationAsync(GetEnrollmentStatusesForOrganizationRequest request) {
        return this.getEnrollmentStatusesForOrganizationAsync(request, null);
    }

    @Override
    public Future<GetEnrollmentStatusesForOrganizationResult> getEnrollmentStatusesForOrganizationAsync(GetEnrollmentStatusesForOrganizationRequest request, final AsyncHandler<GetEnrollmentStatusesForOrganizationRequest, GetEnrollmentStatusesForOrganizationResult> asyncHandler) {
        final GetEnrollmentStatusesForOrganizationRequest finalRequest = (GetEnrollmentStatusesForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEnrollmentStatusesForOrganizationResult>(){

            @Override
            public GetEnrollmentStatusesForOrganizationResult call() throws Exception {
                GetEnrollmentStatusesForOrganizationResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetEnrollmentStatusesForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLambdaFunctionRecommendationsResult> getLambdaFunctionRecommendationsAsync(GetLambdaFunctionRecommendationsRequest request) {
        return this.getLambdaFunctionRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetLambdaFunctionRecommendationsResult> getLambdaFunctionRecommendationsAsync(GetLambdaFunctionRecommendationsRequest request, final AsyncHandler<GetLambdaFunctionRecommendationsRequest, GetLambdaFunctionRecommendationsResult> asyncHandler) {
        final GetLambdaFunctionRecommendationsRequest finalRequest = (GetLambdaFunctionRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLambdaFunctionRecommendationsResult>(){

            @Override
            public GetLambdaFunctionRecommendationsResult call() throws Exception {
                GetLambdaFunctionRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetLambdaFunctionRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecommendationPreferencesResult> getRecommendationPreferencesAsync(GetRecommendationPreferencesRequest request) {
        return this.getRecommendationPreferencesAsync(request, null);
    }

    @Override
    public Future<GetRecommendationPreferencesResult> getRecommendationPreferencesAsync(GetRecommendationPreferencesRequest request, final AsyncHandler<GetRecommendationPreferencesRequest, GetRecommendationPreferencesResult> asyncHandler) {
        final GetRecommendationPreferencesRequest finalRequest = (GetRecommendationPreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRecommendationPreferencesResult>(){

            @Override
            public GetRecommendationPreferencesResult call() throws Exception {
                GetRecommendationPreferencesResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetRecommendationPreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecommendationSummariesResult> getRecommendationSummariesAsync(GetRecommendationSummariesRequest request) {
        return this.getRecommendationSummariesAsync(request, null);
    }

    @Override
    public Future<GetRecommendationSummariesResult> getRecommendationSummariesAsync(GetRecommendationSummariesRequest request, final AsyncHandler<GetRecommendationSummariesRequest, GetRecommendationSummariesResult> asyncHandler) {
        final GetRecommendationSummariesRequest finalRequest = (GetRecommendationSummariesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRecommendationSummariesResult>(){

            @Override
            public GetRecommendationSummariesResult call() throws Exception {
                GetRecommendationSummariesResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetRecommendationSummaries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRecommendationPreferencesResult> putRecommendationPreferencesAsync(PutRecommendationPreferencesRequest request) {
        return this.putRecommendationPreferencesAsync(request, null);
    }

    @Override
    public Future<PutRecommendationPreferencesResult> putRecommendationPreferencesAsync(PutRecommendationPreferencesRequest request, final AsyncHandler<PutRecommendationPreferencesRequest, PutRecommendationPreferencesResult> asyncHandler) {
        final PutRecommendationPreferencesRequest finalRequest = (PutRecommendationPreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRecommendationPreferencesResult>(){

            @Override
            public PutRecommendationPreferencesResult call() throws Exception {
                PutRecommendationPreferencesResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executePutRecommendationPreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEnrollmentStatusResult> updateEnrollmentStatusAsync(UpdateEnrollmentStatusRequest request) {
        return this.updateEnrollmentStatusAsync(request, null);
    }

    @Override
    public Future<UpdateEnrollmentStatusResult> updateEnrollmentStatusAsync(UpdateEnrollmentStatusRequest request, final AsyncHandler<UpdateEnrollmentStatusRequest, UpdateEnrollmentStatusResult> asyncHandler) {
        final UpdateEnrollmentStatusRequest finalRequest = (UpdateEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEnrollmentStatusResult>(){

            @Override
            public UpdateEnrollmentStatusResult call() throws Exception {
                UpdateEnrollmentStatusResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeUpdateEnrollmentStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

