/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.ActionExecutionResult;
import com.amazonaws.services.codepipeline.model.ArtifactDetail;
import com.amazonaws.services.codepipeline.model.transform.ActionExecutionOutputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionExecutionOutput
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ArtifactDetail> outputArtifacts;
    private ActionExecutionResult executionResult;
    private Map<String, String> outputVariables;

    public List<ArtifactDetail> getOutputArtifacts() {
        return this.outputArtifacts;
    }

    public void setOutputArtifacts(Collection<ArtifactDetail> outputArtifacts) {
        if (outputArtifacts == null) {
            this.outputArtifacts = null;
            return;
        }
        this.outputArtifacts = new ArrayList<ArtifactDetail>(outputArtifacts);
    }

    public ActionExecutionOutput withOutputArtifacts(ArtifactDetail ... outputArtifacts) {
        if (this.outputArtifacts == null) {
            this.setOutputArtifacts(new ArrayList<ArtifactDetail>(outputArtifacts.length));
        }
        for (ArtifactDetail ele : outputArtifacts) {
            this.outputArtifacts.add(ele);
        }
        return this;
    }

    public ActionExecutionOutput withOutputArtifacts(Collection<ArtifactDetail> outputArtifacts) {
        this.setOutputArtifacts(outputArtifacts);
        return this;
    }

    public void setExecutionResult(ActionExecutionResult executionResult) {
        this.executionResult = executionResult;
    }

    public ActionExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public ActionExecutionOutput withExecutionResult(ActionExecutionResult executionResult) {
        this.setExecutionResult(executionResult);
        return this;
    }

    public Map<String, String> getOutputVariables() {
        return this.outputVariables;
    }

    public void setOutputVariables(Map<String, String> outputVariables) {
        this.outputVariables = outputVariables;
    }

    public ActionExecutionOutput withOutputVariables(Map<String, String> outputVariables) {
        this.setOutputVariables(outputVariables);
        return this;
    }

    public ActionExecutionOutput addOutputVariablesEntry(String key, String value) {
        if (null == this.outputVariables) {
            this.outputVariables = new HashMap<String, String>();
        }
        if (this.outputVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.outputVariables.put(key, value);
        return this;
    }

    public ActionExecutionOutput clearOutputVariablesEntries() {
        this.outputVariables = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOutputArtifacts() != null) {
            sb.append("OutputArtifacts: ").append(this.getOutputArtifacts()).append(",");
        }
        if (this.getExecutionResult() != null) {
            sb.append("ExecutionResult: ").append(this.getExecutionResult()).append(",");
        }
        if (this.getOutputVariables() != null) {
            sb.append("OutputVariables: ").append(this.getOutputVariables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionOutput)) {
            return false;
        }
        ActionExecutionOutput other = (ActionExecutionOutput)obj;
        if (other.getOutputArtifacts() == null ^ this.getOutputArtifacts() == null) {
            return false;
        }
        if (other.getOutputArtifacts() != null && !other.getOutputArtifacts().equals(this.getOutputArtifacts())) {
            return false;
        }
        if (other.getExecutionResult() == null ^ this.getExecutionResult() == null) {
            return false;
        }
        if (other.getExecutionResult() != null && !other.getExecutionResult().equals(this.getExecutionResult())) {
            return false;
        }
        if (other.getOutputVariables() == null ^ this.getOutputVariables() == null) {
            return false;
        }
        return other.getOutputVariables() == null || other.getOutputVariables().equals(this.getOutputVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOutputArtifacts() == null ? 0 : this.getOutputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionResult() == null ? 0 : this.getExecutionResult().hashCode());
        hashCode = 31 * hashCode + (this.getOutputVariables() == null ? 0 : this.getOutputVariables().hashCode());
        return hashCode;
    }

    public ActionExecutionOutput clone() {
        try {
            return (ActionExecutionOutput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionExecutionOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

