/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.FrameMetric;
import java.util.List;

@SdkInternalApi
public class FrameMetricMarshaller {
    private static final MarshallingInfo<String> FRAMENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frameName").build();
    private static final MarshallingInfo<List> THREADSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("threadStates").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final FrameMetricMarshaller instance = new FrameMetricMarshaller();

    public static FrameMetricMarshaller getInstance() {
        return instance;
    }

    public void marshall(FrameMetric frameMetric, ProtocolMarshaller protocolMarshaller) {
        if (frameMetric == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)frameMetric.getFrameName(), FRAMENAME_BINDING);
            protocolMarshaller.marshall(frameMetric.getThreadStates(), THREADSTATES_BINDING);
            protocolMarshaller.marshall((Object)frameMetric.getType(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

