/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatchevidently.model.EvaluationRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchEvaluateFeatureRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String project;
    private List<EvaluationRequest> requests;

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public BatchEvaluateFeatureRequest withProject(String project) {
        this.setProject(project);
        return this;
    }

    public List<EvaluationRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(Collection<EvaluationRequest> requests) {
        if (requests == null) {
            this.requests = null;
            return;
        }
        this.requests = new ArrayList<EvaluationRequest>(requests);
    }

    public BatchEvaluateFeatureRequest withRequests(EvaluationRequest ... requests) {
        if (this.requests == null) {
            this.setRequests(new ArrayList<EvaluationRequest>(requests.length));
        }
        for (EvaluationRequest ele : requests) {
            this.requests.add(ele);
        }
        return this;
    }

    public BatchEvaluateFeatureRequest withRequests(Collection<EvaluationRequest> requests) {
        this.setRequests(requests);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getRequests() != null) {
            sb.append("Requests: ").append(this.getRequests());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchEvaluateFeatureRequest)) {
            return false;
        }
        BatchEvaluateFeatureRequest other = (BatchEvaluateFeatureRequest)obj;
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getRequests() == null ^ this.getRequests() == null) {
            return false;
        }
        return other.getRequests() == null || other.getRequests().equals(this.getRequests());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getRequests() == null ? 0 : this.getRequests().hashCode());
        return hashCode;
    }

    public BatchEvaluateFeatureRequest clone() {
        return (BatchEvaluateFeatureRequest)super.clone();
    }
}

