/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.Budget;
import com.amazonaws.services.budgets.model.transform.CalculatedSpendJsonMarshaller;
import com.amazonaws.services.budgets.model.transform.CostTypesJsonMarshaller;
import com.amazonaws.services.budgets.model.transform.SpendJsonMarshaller;
import com.amazonaws.services.budgets.model.transform.TimePeriodJsonMarshaller;
import java.util.List;
import java.util.Map;

public class BudgetJsonMarshaller {
    private static BudgetJsonMarshaller instance;

    public void marshall(Budget budget, StructuredJsonGenerator jsonGenerator) {
        if (budget == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, List<String>> costFiltersMap;
            jsonGenerator.writeStartObject();
            if (budget.getBudgetName() != null) {
                jsonGenerator.writeFieldName("BudgetName").writeValue(budget.getBudgetName());
            }
            if (budget.getBudgetLimit() != null) {
                jsonGenerator.writeFieldName("BudgetLimit");
                SpendJsonMarshaller.getInstance().marshall(budget.getBudgetLimit(), jsonGenerator);
            }
            if ((costFiltersMap = budget.getCostFilters()) != null) {
                jsonGenerator.writeFieldName("CostFilters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> costFiltersMapValue : costFiltersMap.entrySet()) {
                    if (costFiltersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(costFiltersMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String costFiltersMapValueList : costFiltersMapValue.getValue()) {
                        if (costFiltersMapValueList == null) continue;
                        jsonGenerator.writeValue(costFiltersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (budget.getCostTypes() != null) {
                jsonGenerator.writeFieldName("CostTypes");
                CostTypesJsonMarshaller.getInstance().marshall(budget.getCostTypes(), jsonGenerator);
            }
            if (budget.getTimeUnit() != null) {
                jsonGenerator.writeFieldName("TimeUnit").writeValue(budget.getTimeUnit());
            }
            if (budget.getTimePeriod() != null) {
                jsonGenerator.writeFieldName("TimePeriod");
                TimePeriodJsonMarshaller.getInstance().marshall(budget.getTimePeriod(), jsonGenerator);
            }
            if (budget.getCalculatedSpend() != null) {
                jsonGenerator.writeFieldName("CalculatedSpend");
                CalculatedSpendJsonMarshaller.getInstance().marshall(budget.getCalculatedSpend(), jsonGenerator);
            }
            if (budget.getBudgetType() != null) {
                jsonGenerator.writeFieldName("BudgetType").writeValue(budget.getBudgetType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BudgetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BudgetJsonMarshaller();
        }
        return instance;
    }
}

