/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.EksContainerOverride;
import com.amazonaws.services.batch.model.EksMetadata;
import com.amazonaws.services.batch.model.transform.EksPodPropertiesOverrideMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EksPodPropertiesOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private List<EksContainerOverride> containers;
    private List<EksContainerOverride> initContainers;
    private EksMetadata metadata;

    public List<EksContainerOverride> getContainers() {
        return this.containers;
    }

    public void setContainers(Collection<EksContainerOverride> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        this.containers = new ArrayList<EksContainerOverride>(containers);
    }

    public EksPodPropertiesOverride withContainers(EksContainerOverride ... containers) {
        if (this.containers == null) {
            this.setContainers(new ArrayList<EksContainerOverride>(containers.length));
        }
        for (EksContainerOverride ele : containers) {
            this.containers.add(ele);
        }
        return this;
    }

    public EksPodPropertiesOverride withContainers(Collection<EksContainerOverride> containers) {
        this.setContainers(containers);
        return this;
    }

    public List<EksContainerOverride> getInitContainers() {
        return this.initContainers;
    }

    public void setInitContainers(Collection<EksContainerOverride> initContainers) {
        if (initContainers == null) {
            this.initContainers = null;
            return;
        }
        this.initContainers = new ArrayList<EksContainerOverride>(initContainers);
    }

    public EksPodPropertiesOverride withInitContainers(EksContainerOverride ... initContainers) {
        if (this.initContainers == null) {
            this.setInitContainers(new ArrayList<EksContainerOverride>(initContainers.length));
        }
        for (EksContainerOverride ele : initContainers) {
            this.initContainers.add(ele);
        }
        return this;
    }

    public EksPodPropertiesOverride withInitContainers(Collection<EksContainerOverride> initContainers) {
        this.setInitContainers(initContainers);
        return this;
    }

    public void setMetadata(EksMetadata metadata) {
        this.metadata = metadata;
    }

    public EksMetadata getMetadata() {
        return this.metadata;
    }

    public EksPodPropertiesOverride withMetadata(EksMetadata metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getInitContainers() != null) {
            sb.append("InitContainers: ").append(this.getInitContainers()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksPodPropertiesOverride)) {
            return false;
        }
        EksPodPropertiesOverride other = (EksPodPropertiesOverride)obj;
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getInitContainers() == null ^ this.getInitContainers() == null) {
            return false;
        }
        if (other.getInitContainers() != null && !other.getInitContainers().equals(this.getInitContainers())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        return other.getMetadata() == null || other.getMetadata().equals(this.getMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getInitContainers() == null ? 0 : this.getInitContainers().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        return hashCode;
    }

    public EksPodPropertiesOverride clone() {
        try {
            return (EksPodPropertiesOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EksPodPropertiesOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

