/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.util;

import java.util.concurrent.locks.Lock;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessTypeNode;
import net.sourceforge.pmd.lang.java.ast.Token;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;

public class NodeUtils {
    public static final String LOCK_NAME = "lock";
    public static final String LOCK_INTERRUPTIBLY_NAME = "lockInterruptibly";
    public static final String UN_LOCK_NAME = "unlock";

    public static boolean isParentOrSelf(Node descendant, Node ancestor) {
        Node parent;
        if (descendant == ancestor) {
            return true;
        }
        if (descendant == null || ancestor == null) {
            return false;
        }
        for (parent = descendant.jjtGetParent(); parent != ancestor && parent != null; parent = parent.jjtGetParent()) {
        }
        return parent == ancestor;
    }

    public static boolean isWrapperType(ASTPrimaryExpression expression) {
        return TypeHelper.isA((TypeNode)expression, Integer.class) || TypeHelper.isA((TypeNode)expression, Long.class) || TypeHelper.isA((TypeNode)expression, Boolean.class) || TypeHelper.isA((TypeNode)expression, Byte.class) || TypeHelper.isA((TypeNode)expression, Double.class) || TypeHelper.isA((TypeNode)expression, Short.class) || TypeHelper.isA((TypeNode)expression, Float.class) || TypeHelper.isA((TypeNode)expression, Character.class);
    }

    public static boolean isConstant(ASTFieldDeclaration field) {
        return field != null && field.isStatic() && field.isFinal();
    }

    public static Class<?> getNodeType(AbstractJavaAccessTypeNode node) {
        return node == null ? null : node.getType();
    }

    public static boolean isLockStatementExpression(ASTStatementExpression statementExpression) {
        return NodeUtils.isLockTypeAndMethod(statementExpression, LOCK_NAME);
    }

    public static boolean isUnLockStatementExpression(ASTStatementExpression statementExpression) {
        return NodeUtils.isLockTypeAndMethod(statementExpression, UN_LOCK_NAME);
    }

    private static boolean isLockTypeAndMethod(ASTStatementExpression statementExpression, String methodName) {
        ASTName name = (ASTName)statementExpression.getFirstDescendantOfType(ASTName.class);
        if (name == null || name.getType() == null || !Lock.class.isAssignableFrom(name.getType())) {
            return false;
        }
        Token token = (Token)name.jjtGetLastToken();
        return methodName.equals(token.image);
    }

    public static boolean isLockNode(Node node) {
        if (!(node instanceof ASTStatementExpression)) {
            return false;
        }
        ASTStatementExpression statementExpression = (ASTStatementExpression)node;
        return NodeUtils.isLockStatementExpression(statementExpression);
    }
}

