/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry;

import cn.ponfee.scheduler.common.util.ClassUtils;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import java.lang.reflect.Modifier;
import org.springframework.util.Assert;

public enum ServerRole {
    WORKER(Worker.class, "distributed.scheduler.workers"),
    SUPERVISOR(Supervisor.class, "distributed.scheduler.supervisors");

    private final Class<? extends Server> type;
    private final String key;

    private ServerRole(Class<? extends Server> type, String key) {
        Assert.isTrue((!Modifier.isAbstract(type.getModifiers()) ? 1 : 0) != 0, (String)("Server type cannot be abstract class: " + type));
        this.type = type;
        this.key = key;
    }

    public <T extends Server> Class<T> type() {
        return this.type;
    }

    public String key() {
        return this.key;
    }

    public <T extends Server> T deserialize(String text) {
        return (T)((Server)ClassUtils.invoke(this.type(), (String)"deserialize", (Object[])new Object[]{text}));
    }

    public static ServerRole of(Class<? extends Server> type) {
        for (ServerRole value : ServerRole.values()) {
            if (type != value.type) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown server type: " + type);
    }
}

