/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry;

import java.util.function.Consumer;

public interface ConnectionStateListener<C> {
    public void onConnected(C var1);

    public void onDisconnected(C var1);

    public static <C> Builder<C> builder() {
        return new Builder();
    }

    public static final class Builder<C> {
        private Consumer<C> onConnected;
        private Consumer<C> onDisconnected;

        public Builder<C> onConnected(Consumer<C> onConnected) {
            this.onConnected = onConnected;
            return this;
        }

        public Builder<C> onDisconnected(Consumer<C> onDisconnected) {
            this.onDisconnected = onDisconnected;
            return this;
        }

        public ConnectionStateListener<C> build() {
            return new ConnectionStateListener<C>(){

                @Override
                public void onConnected(C client) {
                    if (onConnected != null) {
                        onConnected.accept(client);
                    }
                }

                @Override
                public void onDisconnected(C client) {
                    if (onDisconnected != null) {
                        onDisconnected.accept(client);
                    }
                }
            };
        }
    }
}

