/**
 * Logback: the reliable, generic, fast and flexible logging framework.
 * Copyright (C) 1999-2011, QOS.ch. All rights reserved.
 *
 * This program and the accompanying materials are dual-licensed under
 * either the terms of the Eclipse Public License v1.0 as published by
 * the Eclipse Foundation
 *
 *   or (per the licensee's choosing)
 *
 * under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;

public class PatternLayoutEncoderBase<E> extends LayoutWrappingEncoder<E> {

  String pattern;
  protected boolean outputPatternAsPresentationHeader = true;

  public String getPattern() {
    return pattern;
  }

  public void setPattern(String pattern) {
    this.pattern = pattern;
  }

  public boolean isOutputPatternAsPresentationHeader() {
    return outputPatternAsPresentationHeader;
  }

  public void setOutputPatternAsPresentationHeader(boolean outputPatternAsPresentationHeader) {
    this.outputPatternAsPresentationHeader = outputPatternAsPresentationHeader;
  }

  @Override
  public void setLayout(Layout<E> layout) {
    throw new UnsupportedOperationException("one cannot set the layout of "
        + this.getClass().getName());
  }

}
