/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollingFileAppender<E>
extends FileAppender<E> {
    File activeFileCache;
    TriggeringPolicy<E> triggeringPolicy;
    RollingPolicy rollingPolicy;

    @Override
    public void start() {
        if (this.triggeringPolicy == null) {
            this.addWarn("No TriggeringPolicy was set for the RollingFileAppender named " + this.getName());
            this.addWarn("For more information, please visit http://logback.qos.ch/codes.html#rfa_no_tp");
            return;
        }
        if (this.rollingPolicy != null) {
            this.setFile(this.rollingPolicy.getNewActiveFileName());
            this.activeFileCache = new File(this.getFile());
            this.addInfo("Active log file name: " + this.getFile());
            super.start();
        } else {
            this.addWarn("No RollingPolicy was set for the RollingFileAppender named " + this.getName());
            this.addWarn("For more information, please visit http://logback.qos.ch/codes.html#rfa_no_rp");
        }
    }

    public void rollover() {
        this.closeWriter();
        this.append = false;
        try {
            this.rollingPolicy.rollover();
        }
        catch (RolloverFailure rf) {
            this.addWarn("RolloverFailure occurred. Deferring roll-over.");
            this.append = true;
        }
        try {
            this.openFile();
        }
        catch (IOException e) {
            this.addError("setFile(" + this.fileName + ", false) call failed.", e);
        }
    }

    @Override
    protected void subAppend(E event) {
        if (this.triggeringPolicy.isTriggeringEvent(this.activeFileCache, event)) {
            this.rollover();
        }
        super.subAppend(event);
    }

    public RollingPolicy getRollingPolicy() {
        return this.rollingPolicy;
    }

    public TriggeringPolicy getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    public void setRollingPolicy(RollingPolicy policy) {
        this.rollingPolicy = policy;
        if (this.rollingPolicy instanceof TriggeringPolicy) {
            this.triggeringPolicy = (TriggeringPolicy)((Object)policy);
        }
    }

    public void setTriggeringPolicy(TriggeringPolicy<E> policy) {
        this.triggeringPolicy = policy;
        if (policy instanceof RollingPolicy) {
            this.rollingPolicy = (RollingPolicy)((Object)policy);
        }
    }
}

