/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="User", profile="http://hl7.org/fhir/profiles/User", id="user")
public class User
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="name", path="User.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="provider", path="User.provider", description="", type="token")
    public static final String SP_PROVIDER = "provider";
    public static final TokenClientParam PROVIDER = new TokenClientParam("provider");
    @SearchParamDefinition(name="login", path="User.login", description="", type="string")
    public static final String SP_LOGIN = "login";
    public static final StringClientParam LOGIN = new StringClientParam("login");
    @SearchParamDefinition(name="level", path="User.level", description="", type="token")
    public static final String SP_LEVEL = "level";
    public static final TokenClientParam LEVEL = new TokenClientParam("level");
    @SearchParamDefinition(name="patient", path="User.patient", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("User:patient");
    @Child(name="name", type={HumanNameDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private HumanNameDt myName;
    @Child(name="provider", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private UriDt myProvider;
    @Child(name="login", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private StringDt myLogin;
    @Child(name="password", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private StringDt myPassword;
    @Child(name="level", type={CodeDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/user-level")
    private CodeDt myLevel;
    @Child(name="sessionLength", type={IntegerDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private IntegerDt mySessionLength;
    @Child(name="contact", type={ContactPointDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<ContactPointDt> myContact;
    @Child(name="patient", order=7, min=0, max=-1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="")
    private List<ResourceReferenceDt> myPatient;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myProvider, this.myLogin, this.myPassword, this.myLevel, this.mySessionLength, this.myContact, this.myPatient});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myProvider, this.myLogin, this.myPassword, this.myLevel, this.mySessionLength, this.myContact, this.myPatient});
    }

    public HumanNameDt getName() {
        if (this.myName == null) {
            this.myName = new HumanNameDt();
        }
        return this.myName;
    }

    public User setName(HumanNameDt theValue) {
        this.myName = theValue;
        return this;
    }

    public UriDt getProviderElement() {
        if (this.myProvider == null) {
            this.myProvider = new UriDt();
        }
        return this.myProvider;
    }

    public String getProvider() {
        return (String)this.getProviderElement().getValue();
    }

    public User setProvider(UriDt theValue) {
        this.myProvider = theValue;
        return this;
    }

    public User setProvider(String theUri) {
        this.myProvider = new UriDt(theUri);
        return this;
    }

    public StringDt getLoginElement() {
        if (this.myLogin == null) {
            this.myLogin = new StringDt();
        }
        return this.myLogin;
    }

    public String getLogin() {
        return (String)this.getLoginElement().getValue();
    }

    public User setLogin(StringDt theValue) {
        this.myLogin = theValue;
        return this;
    }

    public User setLogin(String theString) {
        this.myLogin = new StringDt(theString);
        return this;
    }

    public StringDt getPasswordElement() {
        if (this.myPassword == null) {
            this.myPassword = new StringDt();
        }
        return this.myPassword;
    }

    public String getPassword() {
        return (String)this.getPasswordElement().getValue();
    }

    public User setPassword(StringDt theValue) {
        this.myPassword = theValue;
        return this;
    }

    public User setPassword(String theString) {
        this.myPassword = new StringDt(theString);
        return this;
    }

    public CodeDt getLevelElement() {
        if (this.myLevel == null) {
            this.myLevel = new CodeDt();
        }
        return this.myLevel;
    }

    public String getLevel() {
        return (String)this.getLevelElement().getValue();
    }

    public User setLevel(CodeDt theValue) {
        this.myLevel = theValue;
        return this;
    }

    public User setLevel(String theCode) {
        this.myLevel = new CodeDt(theCode);
        return this;
    }

    public IntegerDt getSessionLengthElement() {
        if (this.mySessionLength == null) {
            this.mySessionLength = new IntegerDt();
        }
        return this.mySessionLength;
    }

    public Integer getSessionLength() {
        return (Integer)this.getSessionLengthElement().getValue();
    }

    public User setSessionLength(IntegerDt theValue) {
        this.mySessionLength = theValue;
        return this;
    }

    public User setSessionLength(int theInteger) {
        this.mySessionLength = new IntegerDt(theInteger);
        return this;
    }

    public List<ContactPointDt> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactPointDt>();
        }
        return this.myContact;
    }

    public User setContact(List<ContactPointDt> theValue) {
        this.myContact = theValue;
        return this;
    }

    public ContactPointDt addContact() {
        ContactPointDt newType = new ContactPointDt();
        this.getContact().add(newType);
        return newType;
    }

    public User addContact(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public ContactPointDt getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<ResourceReferenceDt> getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ArrayList<ResourceReferenceDt>();
        }
        return this.myPatient;
    }

    public User setPatient(List<ResourceReferenceDt> theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt addPatient() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getPatient().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "User";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

