/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.ElementDefinitionDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ExtensionContextEnum;
import ca.uhn.fhir.model.dstu2.valueset.StructureDefinitionKindEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="StructureDefinition", profile="http://hl7.org/fhir/profiles/StructureDefinition", id="structuredefinition")
public class StructureDefinition
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="url", path="StructureDefinition.url", description="", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="identifier", path="StructureDefinition.identifier", description="The identifier of the profile", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="StructureDefinition.version", description="The version identifier of the profile", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="StructureDefinition.name", description="Name of the profile", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="StructureDefinition.publisher", description="Name of the publisher of the profile", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="StructureDefinition.description", description="Text search in the description of the profile", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="StructureDefinition.status", description="The current status of the profile", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="StructureDefinition.date", description="The profile publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="code", path="StructureDefinition.code", description="A code for the profile", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="valueset", path="StructureDefinition.snapshot.element.binding.valueSet[x]", description="A vocabulary binding reference", type="reference")
    public static final String SP_VALUESET = "valueset";
    public static final ReferenceClientParam VALUESET = new ReferenceClientParam("valueset");
    @SearchParamDefinition(name="type", path="StructureDefinition.constrainedType", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="kind", path="StructureDefinition.kind", description="", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="path", path="StructureDefinition.snapshot.element.path | StructureDefinition.differential.element.path ", description="A path that is constrained in the profile", type="token")
    public static final String SP_PATH = "path";
    public static final TokenClientParam PATH = new TokenClientParam("path");
    @SearchParamDefinition(name="context", path="StructureDefinition.useContext", description="A use context assigned to the structure", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="display", path="StructureDefinition.display", description="", type="string")
    public static final String SP_DISPLAY = "display";
    public static final StringClientParam DISPLAY = new StringClientParam("display");
    @SearchParamDefinition(name="experimental", path="StructureDefinition.experimental", description="", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="abstract", path="StructureDefinition.abstract", description="", type="token")
    public static final String SP_ABSTRACT = "abstract";
    public static final TokenClientParam ABSTRACT = new TokenClientParam("abstract");
    @SearchParamDefinition(name="context-type", path="StructureDefinition.contextType", description="", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="ext-context", path="StructureDefinition.context", description="", type="string")
    public static final String SP_EXT_CONTEXT = "ext-context";
    public static final StringClientParam EXT_CONTEXT = new StringClientParam("ext-context");
    @SearchParamDefinition(name="base", path="StructureDefinition.base", description="", type="uri")
    public static final String SP_BASE = "base";
    public static final UriClientParam BASE = new UriClientParam("base");
    @SearchParamDefinition(name="base-path", path="StructureDefinition.snapshot.element.base.path | StructureDefinition.differential.element.base.path ", description="", type="token")
    public static final String SP_BASE_PATH = "base-path";
    public static final TokenClientParam BASE_PATH = new TokenClientParam("base-path");
    public static final Include INCLUDE_VALUESET = new Include("StructureDefinition:valueset");
    @Child(name="url", type={UriDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="An absolute URL that is used to identify this structure definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this structure definition is (or will be) published")
    private UriDt myUrl;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Formal identifier that is used to identify this StructureDefinition when it is represented in other formats, or referenced in a specification, model, design or an instance  (should be globally unique OID, UUID, or URI), (if it's not possible to use the literal URI)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="version", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id.version", formalDefinition="The identifier that is used to identify this version of the StructureDefinition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the StructureDefinition author manually")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language name identifying the StructureDefinition")
    private StringDt myName;
    @Child(name="display", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Defined so that applications can use this name when displaying the value of the extension to the user")
    private StringDt myDisplay;
    @Child(name="status", type={CodeDt.class}, order=5, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="status", formalDefinition="The status of the StructureDefinition")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/conformance-resource-status")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="This StructureDefinition was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="publisher", type={StringDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="who.witness", formalDefinition="The name of the individual or organization that published the structure definition")
    private StringDt myPublisher;
    @Child(name="contact", order=8, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="date", type={DateTimeDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date this version of the structure definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the structure definition changes")
    private DateTimeDt myDate;
    @Child(name="description", type={StringDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language description of the StructureDefinition and its use")
    private StringDt myDescription;
    @Child(name="useContext", type={CodeableConceptDt.class}, order=11, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of structure definitions.")
    private List<CodeableConceptDt> myUseContext;
    @Child(name="requirements", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="why", formalDefinition="Explains why this structure definition is needed and why it's been constrained as it has")
    private StringDt myRequirements;
    @Child(name="copyright", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A copyright statement relating to the structure definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings")
    private StringDt myCopyright;
    @Child(name="code", type={CodingDt.class}, order=14, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A set of terms from external terminologies that may be used to assist with indexing and searching of templates.")
    private List<CodingDt> myCode;
    @Child(name="fhirVersion", type={IdDt.class}, order=15, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the FHIR specification on which this StructureDefinition is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is $version$ for this version")
    private IdDt myFhirVersion;
    @Child(name="mapping", order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="An external specification that the content is mapped to")
    private List<Mapping> myMapping;
    @Child(name="kind", type={CodeDt.class}, order=17, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Defines the kind of structure that this definition is describing")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/structure-definition-kind")
    private BoundCodeDt<StructureDefinitionKindEnum> myKind;
    @Child(name="constrainedType", type={CodeDt.class}, order=18, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The type of type that is being constrained - a data type, an extension, a resource, including abstract ones. If this field is present, it indicates that the structure definition is a constraint. If it is not present, then the structure definition is the definition of a base structure")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
    private CodeDt myConstrainedType;
    @Child(name="abstract", type={BooleanDt.class}, order=19, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Whether structure this definition describes is abstract or not  - that is, whether an actual exchanged item can ever be of this type")
    private BooleanDt myAbstract;
    @Child(name="contextType", type={CodeDt.class}, order=20, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="If this is an extension, Identifies the context within FHIR resources where the extension can be used")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/extension-context")
    private BoundCodeDt<ExtensionContextEnum> myContextType;
    @Child(name="context", type={StringDt.class}, order=21, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the types of resource or data type elements to which the extension can be applied")
    private List<StringDt> myContext;
    @Child(name="base", type={UriDt.class}, order=22, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="An absolute URI that is the base structure from which this set of constraints is derived")
    private UriDt myBase;
    @Child(name="snapshot", order=23, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A snapshot view is expressed in a stand alone form that can be used and interpreted without considering the base StructureDefinition")
    private Snapshot mySnapshot;
    @Child(name="differential", order=24, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A differential view is expressed relative to the base StructureDefinition - a statement of differences that it applies")
    private Differential myDifferential;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUrl, this.myIdentifier, this.myVersion, this.myName, this.myDisplay, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myUseContext, this.myRequirements, this.myCopyright, this.myCode, this.myFhirVersion, this.myMapping, this.myKind, this.myConstrainedType, this.myAbstract, this.myContextType, this.myContext, this.myBase, this.mySnapshot, this.myDifferential});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myIdentifier, this.myVersion, this.myName, this.myDisplay, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myUseContext, this.myRequirements, this.myCopyright, this.myCode, this.myFhirVersion, this.myMapping, this.myKind, this.myConstrainedType, this.myAbstract, this.myContextType, this.myContext, this.myBase, this.mySnapshot, this.myDifferential});
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public StructureDefinition setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public StructureDefinition setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public StructureDefinition setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public StructureDefinition addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public StructureDefinition setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public StructureDefinition setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public StructureDefinition setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public StructureDefinition setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public StringDt getDisplayElement() {
        if (this.myDisplay == null) {
            this.myDisplay = new StringDt();
        }
        return this.myDisplay;
    }

    public String getDisplay() {
        return (String)this.getDisplayElement().getValue();
    }

    public StructureDefinition setDisplay(StringDt theValue) {
        this.myDisplay = theValue;
        return this;
    }

    public StructureDefinition setDisplay(String theString) {
        this.myDisplay = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public StructureDefinition setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public StructureDefinition setStatus(ConformanceResourceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ConformanceResourceStatusEnum>)new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Boolean getExperimental() {
        return (Boolean)this.getExperimentalElement().getValue();
    }

    public StructureDefinition setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public StructureDefinition setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public StructureDefinition setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public StructureDefinition setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public StructureDefinition setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public StructureDefinition addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public StructureDefinition setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public StructureDefinition setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public StructureDefinition setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public StructureDefinition setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public StructureDefinition setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getUseContext() {
        if (this.myUseContext == null) {
            this.myUseContext = new ArrayList<CodeableConceptDt>();
        }
        return this.myUseContext;
    }

    public StructureDefinition setUseContext(List<CodeableConceptDt> theValue) {
        this.myUseContext = theValue;
        return this;
    }

    public CodeableConceptDt addUseContext() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getUseContext().add(newType);
        return newType;
    }

    public StructureDefinition addUseContext(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUseContext().add(theValue);
        return this;
    }

    public CodeableConceptDt getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            return this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public StringDt getRequirementsElement() {
        if (this.myRequirements == null) {
            this.myRequirements = new StringDt();
        }
        return this.myRequirements;
    }

    public String getRequirements() {
        return (String)this.getRequirementsElement().getValue();
    }

    public StructureDefinition setRequirements(StringDt theValue) {
        this.myRequirements = theValue;
        return this;
    }

    public StructureDefinition setRequirements(String theString) {
        this.myRequirements = new StringDt(theString);
        return this;
    }

    public StringDt getCopyrightElement() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public String getCopyright() {
        return (String)this.getCopyrightElement().getValue();
    }

    public StructureDefinition setCopyright(StringDt theValue) {
        this.myCopyright = theValue;
        return this;
    }

    public StructureDefinition setCopyright(String theString) {
        this.myCopyright = new StringDt(theString);
        return this;
    }

    public List<CodingDt> getCode() {
        if (this.myCode == null) {
            this.myCode = new ArrayList<CodingDt>();
        }
        return this.myCode;
    }

    public StructureDefinition setCode(List<CodingDt> theValue) {
        this.myCode = theValue;
        return this;
    }

    public CodingDt addCode() {
        CodingDt newType = new CodingDt();
        this.getCode().add(newType);
        return newType;
    }

    public StructureDefinition addCode(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCode().add(theValue);
        return this;
    }

    public CodingDt getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            return this.addCode();
        }
        return this.getCode().get(0);
    }

    public IdDt getFhirVersionElement() {
        if (this.myFhirVersion == null) {
            this.myFhirVersion = new IdDt();
        }
        return this.myFhirVersion;
    }

    public String getFhirVersion() {
        return this.getFhirVersionElement().getValue();
    }

    public StructureDefinition setFhirVersion(IdDt theValue) {
        this.myFhirVersion = theValue;
        return this;
    }

    public StructureDefinition setFhirVersion(String theId) {
        this.myFhirVersion = new IdDt(theId);
        return this;
    }

    public List<Mapping> getMapping() {
        if (this.myMapping == null) {
            this.myMapping = new ArrayList<Mapping>();
        }
        return this.myMapping;
    }

    public StructureDefinition setMapping(List<Mapping> theValue) {
        this.myMapping = theValue;
        return this;
    }

    public Mapping addMapping() {
        Mapping newType = new Mapping();
        this.getMapping().add(newType);
        return newType;
    }

    public StructureDefinition addMapping(Mapping theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getMapping().add(theValue);
        return this;
    }

    public Mapping getMappingFirstRep() {
        if (this.getMapping().isEmpty()) {
            return this.addMapping();
        }
        return this.getMapping().get(0);
    }

    public BoundCodeDt<StructureDefinitionKindEnum> getKindElement() {
        if (this.myKind == null) {
            this.myKind = new BoundCodeDt(StructureDefinitionKindEnum.VALUESET_BINDER);
        }
        return this.myKind;
    }

    public String getKind() {
        return (String)this.getKindElement().getValue();
    }

    public StructureDefinition setKind(BoundCodeDt<StructureDefinitionKindEnum> theValue) {
        this.myKind = theValue;
        return this;
    }

    public StructureDefinition setKind(StructureDefinitionKindEnum theValue) {
        this.setKind((BoundCodeDt<StructureDefinitionKindEnum>)new BoundCodeDt(StructureDefinitionKindEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeDt getConstrainedTypeElement() {
        if (this.myConstrainedType == null) {
            this.myConstrainedType = new CodeDt();
        }
        return this.myConstrainedType;
    }

    public String getConstrainedType() {
        return (String)this.getConstrainedTypeElement().getValue();
    }

    public StructureDefinition setConstrainedType(CodeDt theValue) {
        this.myConstrainedType = theValue;
        return this;
    }

    public StructureDefinition setConstrainedType(String theCode) {
        this.myConstrainedType = new CodeDt(theCode);
        return this;
    }

    public BooleanDt getAbstractElement() {
        if (this.myAbstract == null) {
            this.myAbstract = new BooleanDt();
        }
        return this.myAbstract;
    }

    public Boolean getAbstract() {
        return (Boolean)this.getAbstractElement().getValue();
    }

    public StructureDefinition setAbstract(BooleanDt theValue) {
        this.myAbstract = theValue;
        return this;
    }

    public StructureDefinition setAbstract(boolean theBoolean) {
        this.myAbstract = new BooleanDt(theBoolean);
        return this;
    }

    public BoundCodeDt<ExtensionContextEnum> getContextTypeElement() {
        if (this.myContextType == null) {
            this.myContextType = new BoundCodeDt(ExtensionContextEnum.VALUESET_BINDER);
        }
        return this.myContextType;
    }

    public String getContextType() {
        return (String)this.getContextTypeElement().getValue();
    }

    public StructureDefinition setContextType(BoundCodeDt<ExtensionContextEnum> theValue) {
        this.myContextType = theValue;
        return this;
    }

    public StructureDefinition setContextType(ExtensionContextEnum theValue) {
        this.setContextType((BoundCodeDt<ExtensionContextEnum>)new BoundCodeDt(ExtensionContextEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<StringDt> getContext() {
        if (this.myContext == null) {
            this.myContext = new ArrayList<StringDt>();
        }
        return this.myContext;
    }

    public StructureDefinition setContext(List<StringDt> theValue) {
        this.myContext = theValue;
        return this;
    }

    public StringDt addContext() {
        StringDt newType = new StringDt();
        this.getContext().add(newType);
        return newType;
    }

    public StructureDefinition addContext(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContext().add(theValue);
        return this;
    }

    public StringDt getContextFirstRep() {
        if (this.getContext().isEmpty()) {
            return this.addContext();
        }
        return this.getContext().get(0);
    }

    public StructureDefinition addContext(String theString) {
        if (this.myContext == null) {
            this.myContext = new ArrayList<StringDt>();
        }
        this.myContext.add(new StringDt(theString));
        return this;
    }

    public UriDt getBaseElement() {
        if (this.myBase == null) {
            this.myBase = new UriDt();
        }
        return this.myBase;
    }

    public String getBase() {
        return (String)this.getBaseElement().getValue();
    }

    public StructureDefinition setBase(UriDt theValue) {
        this.myBase = theValue;
        return this;
    }

    public StructureDefinition setBase(String theUri) {
        this.myBase = new UriDt(theUri);
        return this;
    }

    public Snapshot getSnapshot() {
        if (this.mySnapshot == null) {
            this.mySnapshot = new Snapshot();
        }
        return this.mySnapshot;
    }

    public StructureDefinition setSnapshot(Snapshot theValue) {
        this.mySnapshot = theValue;
        return this;
    }

    public Differential getDifferential() {
        if (this.myDifferential == null) {
            this.myDifferential = new Differential();
        }
        return this.myDifferential;
    }

    public StructureDefinition setDifferential(Differential theValue) {
        this.myDifferential = theValue;
        return this;
    }

    public String getResourceName() {
        return "StructureDefinition";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Differential
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="element", type={ElementDefinitionDt.class}, order=0, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Captures constraints on each element within the resource")
        private List<ElementDefinitionDt> myElement;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty(this.myElement);
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myElement});
        }

        public List<ElementDefinitionDt> getElement() {
            if (this.myElement == null) {
                this.myElement = new ArrayList<ElementDefinitionDt>();
            }
            return this.myElement;
        }

        public Differential setElement(List<ElementDefinitionDt> theValue) {
            this.myElement = theValue;
            return this;
        }

        public ElementDefinitionDt addElement() {
            ElementDefinitionDt newType = new ElementDefinitionDt();
            this.getElement().add(newType);
            return newType;
        }

        public Differential addElement(ElementDefinitionDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getElement().add(theValue);
            return this;
        }

        public ElementDefinitionDt getElementFirstRep() {
            if (this.getElement().isEmpty()) {
                return this.addElement();
            }
            return this.getElement().get(0);
        }
    }

    @Block
    public static class Snapshot
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="element", type={ElementDefinitionDt.class}, order=0, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Captures constraints on each element within the resource")
        private List<ElementDefinitionDt> myElement;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty(this.myElement);
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myElement});
        }

        public List<ElementDefinitionDt> getElement() {
            if (this.myElement == null) {
                this.myElement = new ArrayList<ElementDefinitionDt>();
            }
            return this.myElement;
        }

        public Snapshot setElement(List<ElementDefinitionDt> theValue) {
            this.myElement = theValue;
            return this;
        }

        public ElementDefinitionDt addElement() {
            ElementDefinitionDt newType = new ElementDefinitionDt();
            this.getElement().add(newType);
            return newType;
        }

        public Snapshot addElement(ElementDefinitionDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getElement().add(theValue);
            return this;
        }

        public ElementDefinitionDt getElementFirstRep() {
            if (this.getElement().isEmpty()) {
                return this.addElement();
            }
            return this.getElement().get(0);
        }
    }

    @Block
    public static class Mapping
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identity", type={IdDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An Internal id that is used to identify this mapping set when specific mappings are made")
        private IdDt myIdentity;
        @Child(name="uri", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An absolute URI that identifies the specification that this mapping is expressed to")
        private UriDt myUri;
        @Child(name="name", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A name for the specification that is being mapped to")
        private StringDt myName;
        @Child(name="comments", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage")
        private StringDt myComments;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentity, this.myUri, this.myName, this.myComments});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentity, this.myUri, this.myName, this.myComments});
        }

        public IdDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new IdDt();
            }
            return this.myIdentity;
        }

        public String getIdentity() {
            return this.getIdentityElement().getValue();
        }

        public Mapping setIdentity(IdDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public Mapping setIdentity(String theId) {
            this.myIdentity = new IdDt(theId);
            return this;
        }

        public UriDt getUriElement() {
            if (this.myUri == null) {
                this.myUri = new UriDt();
            }
            return this.myUri;
        }

        public String getUri() {
            return (String)this.getUriElement().getValue();
        }

        public Mapping setUri(UriDt theValue) {
            this.myUri = theValue;
            return this;
        }

        public Mapping setUri(String theUri) {
            this.myUri = new UriDt(theUri);
            return this;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Mapping setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Mapping setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getCommentsElement() {
            if (this.myComments == null) {
                this.myComments = new StringDt();
            }
            return this.myComments;
        }

        public String getComments() {
            return (String)this.getCommentsElement().getValue();
        }

        public Mapping setComments(StringDt theValue) {
            this.myComments = theValue;
            return this;
        }

        public Mapping setComments(String theString) {
            this.myComments = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the structure definition")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }
}

