/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.exceptions;

import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.util.CoverageIgnore;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IIdType;

@CoverageIgnore
public class ResourceGoneException
extends BaseServerResponseException {
    public static final int STATUS_CODE = 410;
    private static final long serialVersionUID = 1L;

    public ResourceGoneException(IIdType theResourceId) {
        super(410, "Resource " + (theResourceId != null ? theResourceId.getValue() : "") + " is gone/deleted");
    }

    @Deprecated
    public ResourceGoneException(Class<? extends IResource> theClass, BaseIdentifierDt thePatientId) {
        super(410, "Resource of type " + theClass.getSimpleName() + " with ID " + thePatientId + " is gone/deleted");
    }

    public ResourceGoneException(Class<? extends IResource> theClass, IIdType theResourceId) {
        super(410, "Resource of type " + theClass.getSimpleName() + " with ID " + theResourceId + " is gone/deleted");
    }

    public ResourceGoneException(String theMessage, IBaseOperationOutcome theOperationOutcome) {
        super(410, theMessage, theOperationOutcome);
    }

    public ResourceGoneException(String theMessage) {
        super(410, theMessage);
    }
}

