/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.IRestfulResponse;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class RestfulResponse<T extends RequestDetails>
implements IRestfulResponse {
    private IIdType myOperationResourceId;
    private IPrimitiveType<Date> myOperationResourceLastUpdated;
    private ConcurrentHashMap<String, String> theHeaders = new ConcurrentHashMap();
    private T theRequestDetails;

    public RestfulResponse(T requestDetails) {
        this.theRequestDetails = requestDetails;
    }

    @Override
    public void addHeader(String headerKey, String headerValue) {
        this.getHeaders().put(headerKey, headerValue);
    }

    public ConcurrentHashMap<String, String> getHeaders() {
        return this.theHeaders;
    }

    public T getRequestDetails() {
        return this.theRequestDetails;
    }

    @Override
    public void setOperationResourceId(IIdType theOperationResourceId) {
        this.myOperationResourceId = theOperationResourceId;
    }

    @Override
    public void setOperationResourceLastUpdated(IPrimitiveType<Date> theOperationResourceLastUpdated) {
        this.myOperationResourceLastUpdated = theOperationResourceLastUpdated;
    }

    public void setRequestDetails(T requestDetails) {
        this.theRequestDetails = requestDetails;
    }

    @Override
    public Object streamResponseAsBundle(Bundle bundle, Set<SummaryEnum> summaryMode, boolean respondGzip, boolean requestIsBrowser) throws IOException {
        return RestfulServerUtils.streamResponseAsBundle(((RequestDetails)this.theRequestDetails).getServer(), bundle, summaryMode, respondGzip, this.getRequestDetails());
    }

    @Override
    public final Object streamResponseAsResource(IBaseResource theResource, boolean thePrettyPrint, Set<SummaryEnum> theSummaryMode, int theStatusCode, String theStatusMessage, boolean theRespondGzip, boolean theAddContentLocation) throws IOException {
        return RestfulServerUtils.streamResponseAsResource(((RequestDetails)this.theRequestDetails).getServer(), theResource, theSummaryMode, theStatusCode, theStatusMessage, theAddContentLocation, theRespondGzip, this.getRequestDetails(), this.myOperationResourceId, this.myOperationResourceLastUpdated);
    }
}

