/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum ParamPrefixEnum {
    APPROXIMATE("~", "ap"),
    ENDS_BEFORE("", "eb"),
    EQUAL("", "eq"),
    GREATERTHAN(">", "gt"),
    GREATERTHAN_OR_EQUALS(">=", "ge"),
    LESSTHAN("<", "lt"),
    LESSTHAN_OR_EQUALS("<=", "le"),
    NOT_EQUAL("", "ne"),
    STARTS_AFTER("", "sa");

    private static final Map<String, ParamPrefixEnum> DSTU1_TO_PREFIX;
    private static final Map<String, ParamPrefixEnum> VALUE_TO_PREFIX;
    private final String myDstu1Value;
    private final String myValue;

    private ParamPrefixEnum(String theDstu1Value, String theValue) {
        this.myDstu1Value = theDstu1Value;
        this.myValue = theValue;
    }

    public String getDstu1Value() {
        return this.myDstu1Value;
    }

    public String getValue() {
        return this.myValue;
    }

    public String getValueForContext(FhirContext theContext) {
        if (theContext.getVersion().getVersion() == FhirVersionEnum.DSTU1) {
            return this.getDstu1Value();
        }
        return this.getValue();
    }

    public static ParamPrefixEnum forDstu1Value(String theValue) {
        return DSTU1_TO_PREFIX.get(theValue);
    }

    public static ParamPrefixEnum forValue(String theValue) {
        return VALUE_TO_PREFIX.get(theValue);
    }

    static {
        HashMap<String, ParamPrefixEnum> valueToPrefix = new HashMap<String, ParamPrefixEnum>();
        HashMap<String, ParamPrefixEnum> dstu1ToPrefix = new HashMap<String, ParamPrefixEnum>();
        for (ParamPrefixEnum next : ParamPrefixEnum.values()) {
            valueToPrefix.put(next.getValue(), next);
            if (!StringUtils.isNotBlank((CharSequence)next.getDstu1Value())) continue;
            dstu1ToPrefix.put(next.getDstu1Value(), next);
        }
        VALUE_TO_PREFIX = Collections.unmodifiableMap(valueToPrefix);
        DSTU1_TO_PREFIX = Collections.unmodifiableMap(dstu1ToPrefix);
    }
}

