/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.method.BaseBinder;
import ca.uhn.fhir.rest.method.IParamBinder;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.QualifiedParamList;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

final class QueryParameterTypeBinder
extends BaseBinder<IQueryParameterType>
implements IParamBinder<IQueryParameterType> {
    QueryParameterTypeBinder(Class<? extends IQueryParameterType> theType, List<Class<? extends IQueryParameterType>> theCompositeTypes) {
        super(theType, theCompositeTypes);
    }

    @Override
    public List<IQueryParameterOr<?>> encode(FhirContext theContext, IQueryParameterType theValue) throws InternalErrorException {
        IQueryParameterType param = theValue;
        List<IQueryParameterOr<?>> retVal = Collections.singletonList(MethodUtil.singleton(param, null));
        return retVal;
    }

    @Override
    public IQueryParameterType parse(FhirContext theContext, String theParamName, List<QualifiedParamList> theParams) throws InternalErrorException, InvalidRequestException {
        String value = (String)theParams.get(0).get(0);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        IQueryParameterType dt = (IQueryParameterType)super.newInstance();
        if (theParams.size() == 0 || theParams.get(0).size() == 0) {
            return dt;
        }
        if (theParams.size() > 1 || theParams.get(0).size() > 1) {
            throw new InvalidRequestException("Multiple values detected for non-repeatable parameter '" + theParamName + "'. This server is not configured to allow multiple (AND/OR) values for this param.");
        }
        dt.setValueAsQueryToken(theContext, theParamName, theParams.get(0).getQualifier(), value);
        return dt;
    }
}

