/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.ValidationModeEnum;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.QualifiedParamList;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.method.SearchParameter;
import ca.uhn.fhir.rest.param.BaseAndListParam;
import ca.uhn.fhir.rest.param.CollectionBinder;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class OperationParameter
implements IParameter {
    private static final Class<? extends IQueryParameterType>[] COMPOSITE_TYPES = new Class[0];
    static final String REQUEST_CONTENTS_USERDATA_KEY = OperationParam.class.getName() + "_PARSED_RESOURCE";
    private boolean myAllowGet;
    private final FhirContext myContext;
    private IOperationParamConverter myConverter;
    private Class<? extends Collection> myInnerCollectionType;
    private int myMax;
    private int myMin;
    private final String myName;
    private final String myOperationName;
    private Class<?> myParameterType;
    private String myParamType;
    private SearchParameter mySearchParameterBinding;

    public OperationParameter(FhirContext theCtx, String theOperationName, OperationParam theOperationParam) {
        this(theCtx, theOperationName, theOperationParam.name(), theOperationParam.min(), theOperationParam.max());
    }

    OperationParameter(FhirContext theCtx, String theOperationName, String theParameterName, int theMin, int theMax) {
        this.myOperationName = theOperationName;
        this.myName = theParameterName;
        this.myMin = theMin;
        this.myMax = theMax;
        this.myContext = theCtx;
    }

    private void addValueToList(List<Object> matchingParamValues, Object values) {
        if (values != null) {
            if (BaseAndListParam.class.isAssignableFrom(this.myParameterType) && matchingParamValues.size() > 0) {
                BaseAndListParam existing = (BaseAndListParam)matchingParamValues.get(0);
                BaseAndListParam newAndList = (BaseAndListParam)values;
                for (IQueryParameterOr nextAnd : newAndList.getValuesAsQueryTokens()) {
                    existing.addAnd(nextAnd);
                }
            } else {
                matchingParamValues.add(values);
            }
        }
    }

    protected FhirContext getContext() {
        return this.myContext;
    }

    public int getMax() {
        return this.myMax;
    }

    public int getMin() {
        return this.myMin;
    }

    public String getName() {
        return this.myName;
    }

    public String getParamType() {
        return this.myParamType;
    }

    public String getSearchParamType() {
        if (this.mySearchParameterBinding != null) {
            return this.mySearchParameterBinding.getParamType().getCode();
        }
        return null;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (this.getContext().getVersion().getVersion().isRi() && IDatatype.class.isAssignableFrom(theParameterType)) {
            throw new ConfigurationException("Incorrect use of type " + theParameterType.getSimpleName() + " as parameter type for method when context is for version " + this.getContext().getVersion().getVersion().name() + " in method: " + theMethod.toString());
        }
        this.myParameterType = theParameterType;
        if (theInnerCollectionType != null) {
            this.myInnerCollectionType = CollectionBinder.getInstantiableCollectionType(theInnerCollectionType, this.myName);
            if (this.myMax == -2) {
                this.myMax = -1;
            }
        } else if (IQueryParameterAnd.class.isAssignableFrom(this.myParameterType)) {
            if (this.myMax == -2) {
                this.myMax = -1;
            }
        } else if (this.myMax == -2) {
            this.myMax = 1;
        }
        boolean typeIsConcrete = !this.myParameterType.isInterface() && !Modifier.isAbstract(this.myParameterType.getModifiers());
        boolean isSearchParam = IQueryParameterType.class.isAssignableFrom(this.myParameterType) || IQueryParameterOr.class.isAssignableFrom(this.myParameterType) || IQueryParameterAnd.class.isAssignableFrom(this.myParameterType);
        boolean bl = this.myAllowGet = IPrimitiveType.class.isAssignableFrom(this.myParameterType) || String.class.equals(this.myParameterType) || (isSearchParam &= typeIsConcrete && !IBase.class.isAssignableFrom(this.myParameterType)) || ValidationModeEnum.class.equals(this.myParameterType);
        if (!this.myParameterType.equals(IBase.class) && !this.myParameterType.equals(String.class)) {
            if (IBaseResource.class.isAssignableFrom(this.myParameterType) && this.myParameterType.isInterface()) {
                this.myParamType = "Resource";
            } else if (DateRangeParam.class.isAssignableFrom(this.myParameterType)) {
                this.myParamType = "date";
                this.myMax = 2;
                this.myAllowGet = true;
            } else if (this.myParameterType.equals(ValidationModeEnum.class)) {
                this.myParamType = "code";
            } else if (IBase.class.isAssignableFrom(this.myParameterType) && typeIsConcrete) {
                this.myParamType = this.myContext.getElementDefinition(this.myParameterType).getName();
            } else if (isSearchParam) {
                this.myParamType = "string";
                this.mySearchParameterBinding = new SearchParameter(this.myName, this.myMin > 0);
                this.mySearchParameterBinding.setCompositeTypes(COMPOSITE_TYPES);
                this.mySearchParameterBinding.setType(this.myContext, theParameterType, theInnerCollectionType, theOuterCollectionType);
                this.myConverter = new OperationParamConverter();
            } else {
                throw new ConfigurationException("Invalid type for @OperationParam: " + this.myParameterType.getName());
            }
        }
    }

    public OperationParameter setConverter(IOperationParamConverter theConverter) {
        this.myConverter = theConverter;
        return this;
    }

    private void throwWrongParamType(Object nextValue) {
        throw new InvalidRequestException("Request has parameter " + this.myName + " of type " + nextValue.getClass().getSimpleName() + " but method expects type " + this.myParameterType.getSimpleName());
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        assert (theTargetResource != null);
        Object sourceClientArgument = theSourceClientArgument;
        if (sourceClientArgument == null) {
            return;
        }
        if (this.myConverter != null) {
            sourceClientArgument = this.myConverter.outgoingClient(sourceClientArgument);
        }
        ParametersUtil.addParameterToParameters(theContext, theTargetResource, sourceClientArgument, this.myName);
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        ArrayList<Object> matchingParamValues = new ArrayList<Object>();
        if (theRequest.getRequestType() == RequestTypeEnum.GET) {
            this.translateQueryParametersIntoServerArgumentForGet(theRequest, matchingParamValues);
        } else {
            this.translateQueryParametersIntoServerArgumentForPost(theRequest, matchingParamValues);
        }
        if (matchingParamValues.isEmpty()) {
            return null;
        }
        if (this.myInnerCollectionType == null) {
            return matchingParamValues.get(0);
        }
        Collection retVal = ReflectionUtil.newInstance(this.myInnerCollectionType);
        retVal.addAll(matchingParamValues);
        return retVal;
    }

    private void translateQueryParametersIntoServerArgumentForGet(RequestDetails theRequest, List<Object> matchingParamValues) {
        if (this.mySearchParameterBinding != null) {
            ArrayList<QualifiedParamList> params = new ArrayList<QualifiedParamList>();
            String nameWithQualifierColon = this.myName + ":";
            for (String nextParamName : theRequest.getParameters().keySet()) {
                String[] values;
                String qualifier;
                if (nextParamName.equals(this.myName)) {
                    qualifier = null;
                } else {
                    if (!nextParamName.startsWith(nameWithQualifierColon)) continue;
                    qualifier = nextParamName.substring(nextParamName.indexOf(58));
                }
                if ((values = theRequest.getParameters().get(nextParamName)) == null) continue;
                for (String nextValue : values) {
                    params.add(QualifiedParamList.splitQueryStringByCommasIgnoreEscape(qualifier, nextValue));
                }
            }
            if (!params.isEmpty()) {
                for (QualifiedParamList next : params) {
                    Object values = this.mySearchParameterBinding.parse(this.myContext, Collections.singletonList(next));
                    this.addValueToList(matchingParamValues, values);
                }
            }
        } else {
            String[] paramValues = theRequest.getParameters().get(this.myName);
            if (paramValues != null && paramValues.length > 0) {
                if (this.myAllowGet) {
                    if (DateRangeParam.class.isAssignableFrom(this.myParameterType)) {
                        ArrayList<QualifiedParamList> parameters = new ArrayList<QualifiedParamList>();
                        parameters.add(QualifiedParamList.singleton(paramValues[0]));
                        if (paramValues.length > 1) {
                            parameters.add(QualifiedParamList.singleton(paramValues[1]));
                        }
                        DateRangeParam dateRangeParam = new DateRangeParam();
                        FhirContext ctx = theRequest.getServer().getFhirContext();
                        dateRangeParam.setValuesAsQueryTokens(ctx, this.myName, parameters);
                        matchingParamValues.add(dateRangeParam);
                    } else if (String.class.isAssignableFrom(this.myParameterType)) {
                        for (String next : paramValues) {
                            matchingParamValues.add(next);
                        }
                    } else if (ValidationModeEnum.class.equals(this.myParameterType)) {
                        if (StringUtils.isNotBlank((CharSequence)paramValues[0])) {
                            ValidationModeEnum validationMode = ValidationModeEnum.forCode(paramValues[0]);
                            if (validationMode != null) {
                                matchingParamValues.add((Object)validationMode);
                            } else {
                                OperationParameter.throwInvalidMode(paramValues[0]);
                            }
                        }
                    } else {
                        for (String nextValue : paramValues) {
                            FhirContext ctx = theRequest.getServer().getFhirContext();
                            RuntimePrimitiveDatatypeDefinition def = (RuntimePrimitiveDatatypeDefinition)ctx.getElementDefinition(this.myParameterType);
                            IPrimitiveType instance = (IPrimitiveType)def.newInstance();
                            instance.setValueAsString(nextValue);
                            matchingParamValues.add(instance);
                        }
                    }
                } else {
                    HapiLocalizer localizer = theRequest.getServer().getFhirContext().getLocalizer();
                    String msg = localizer.getMessage(OperationParameter.class, "urlParamNotPrimitive", this.myOperationName, this.myName);
                    throw new MethodNotAllowedException(msg, RequestTypeEnum.POST);
                }
            }
        }
    }

    private void translateQueryParametersIntoServerArgumentForPost(RequestDetails theRequest, List<Object> matchingParamValues) {
        IBaseResource requestContents = (IBaseResource)theRequest.getUserData().get(REQUEST_CONTENTS_USERDATA_KEY);
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(requestContents);
        if (def.getName().equals("Parameters")) {
            BaseRuntimeChildDefinition paramChild = def.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
            RuntimeChildPrimitiveDatatypeDefinition nameChild = (RuntimeChildPrimitiveDatatypeDefinition)paramChildElem.getChildByName("name");
            BaseRuntimeChildDefinition valueChild = paramChildElem.getChildByName("value[x]");
            BaseRuntimeChildDefinition resourceChild = paramChildElem.getChildByName("resource");
            BaseRuntimeChildDefinition.IAccessor paramChildAccessor = paramChild.getAccessor();
            List<IBase> values = paramChildAccessor.getValues(requestContents);
            for (IBase nextParameter : values) {
                IPrimitiveType nextName;
                List<IBase> nextNames = nameChild.getAccessor().getValues(nextParameter);
                if (nextNames == null || nextNames.size() <= 0 || !this.myName.equals((nextName = (IPrimitiveType)nextNames.get(0)).getValueAsString())) continue;
                if (this.myParameterType.isAssignableFrom(nextParameter.getClass())) {
                    matchingParamValues.add(nextParameter);
                    continue;
                }
                List<IBase> paramValues = valueChild.getAccessor().getValues(nextParameter);
                List<IBase> paramResources = resourceChild.getAccessor().getValues(nextParameter);
                if (paramValues != null && paramValues.size() > 0) {
                    this.tryToAddValues(paramValues, matchingParamValues);
                    continue;
                }
                if (paramResources == null || paramResources.size() <= 0) continue;
                this.tryToAddValues(paramResources, matchingParamValues);
            }
        } else if (this.myParameterType.isAssignableFrom(requestContents.getClass())) {
            this.tryToAddValues(Arrays.asList(requestContents), matchingParamValues);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryToAddValues(List<IBase> theParamValues, List<Object> theMatchingParamValues) {
        for (IBase iBase : theParamValues) {
            void var4_4;
            if (iBase == null) continue;
            if (this.myConverter != null) {
                Object object = this.myConverter.incomingServer(iBase);
            }
            if (!this.myParameterType.isAssignableFrom(var4_4.getClass())) {
                IRuntimeDatatypeDefinition targetTypeDtDef;
                Class<?> sourceType = var4_4.getClass();
                Class<?> targetType = this.myParameterType;
                BaseRuntimeElementDefinition<?> sourceTypeDef = this.myContext.getElementDefinition(sourceType);
                BaseRuntimeElementDefinition<?> targetTypeDef = this.myContext.getElementDefinition(targetType);
                if (targetTypeDef instanceof IRuntimeDatatypeDefinition && sourceTypeDef instanceof IRuntimeDatatypeDefinition && (targetTypeDtDef = (IRuntimeDatatypeDefinition)((Object)targetTypeDef)).isProfileOf(sourceType)) {
                    FhirTerser terser = this.myContext.newTerser();
                    Object newTarget = targetTypeDef.newInstance();
                    terser.cloneInto((IBase)var4_4, (IBase)newTarget, true);
                    theMatchingParamValues.add(newTarget);
                    continue;
                }
                this.throwWrongParamType(var4_4);
            }
            this.addValueToList(theMatchingParamValues, var4_4);
        }
    }

    public static void throwInvalidMode(String paramValues) {
        throw new InvalidRequestException("Invalid mode value: \"" + paramValues + "\"");
    }

    class OperationParamConverter
    implements IOperationParamConverter {
        public OperationParamConverter() {
            Validate.isTrue((OperationParameter.this.mySearchParameterBinding != null ? 1 : 0) != 0);
        }

        @Override
        public Object incomingServer(Object theObject) {
            IPrimitiveType obj = (IPrimitiveType)theObject;
            List<QualifiedParamList> paramList = Collections.singletonList(QualifiedParamList.splitQueryStringByCommasIgnoreEscape(null, obj.getValueAsString()));
            return OperationParameter.this.mySearchParameterBinding.parse(OperationParameter.this.myContext, paramList);
        }

        @Override
        public Object outgoingClient(Object theObject) {
            IQueryParameterType obj = (IQueryParameterType)theObject;
            IPrimitiveType retVal = (IPrimitiveType)OperationParameter.this.myContext.getElementDefinition("string").newInstance();
            retVal.setValueAsString(obj.getValueAsQueryToken(OperationParameter.this.myContext));
            return retVal;
        }
    }

    static interface IOperationParamConverter {
        public Object incomingServer(Object var1);

        public Object outgoingClient(Object var1);
    }
}

