/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.rest.server.EncodingEnum;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IParser {
    public String encodeBundleToString(Bundle var1) throws DataFormatException;

    public void encodeBundleToWriter(Bundle var1, Writer var2) throws IOException, DataFormatException;

    public String encodeResourceToString(IBaseResource var1) throws DataFormatException;

    public void encodeResourceToWriter(IBaseResource var1, Writer var2) throws IOException, DataFormatException;

    public String encodeTagListToString(TagList var1);

    public void encodeTagListToWriter(TagList var1, Writer var2) throws IOException;

    public Set<String> getEncodeElements();

    public Set<String> getEncodeElementsAppliesToResourceTypes();

    public IIdType getEncodeForceResourceId();

    public EncodingEnum getEncoding();

    public List<Class<? extends IBaseResource>> getPreferTypes();

    public boolean isOmitResourceId();

    public Boolean getStripVersionsFromReferences();

    public boolean isSummaryMode();

    public <T extends IBaseResource> Bundle parseBundle(Class<T> var1, Reader var2);

    public Bundle parseBundle(Reader var1);

    public Bundle parseBundle(String var1) throws ConfigurationException, DataFormatException;

    public <T extends IBaseResource> T parseResource(Class<T> var1, Reader var2) throws DataFormatException;

    public <T extends IBaseResource> T parseResource(Class<T> var1, String var2) throws DataFormatException;

    public IBaseResource parseResource(Reader var1) throws ConfigurationException, DataFormatException;

    public IBaseResource parseResource(String var1) throws ConfigurationException, DataFormatException;

    public TagList parseTagList(Reader var1);

    public TagList parseTagList(String var1);

    public void setDontEncodeElements(Set<String> var1);

    public void setEncodeElements(Set<String> var1);

    public void setEncodeElementsAppliesToResourceTypes(Set<String> var1);

    public IParser setEncodeForceResourceId(IIdType var1);

    public IParser setOmitResourceId(boolean var1);

    public IParser setParserErrorHandler(IParserErrorHandler var1);

    public void setPreferTypes(List<Class<? extends IBaseResource>> var1);

    public IParser setPrettyPrint(boolean var1);

    public IParser setServerBaseUrl(String var1);

    public IParser setStripVersionsFromReferences(Boolean var1);

    public IParser setSummaryMode(boolean var1);

    public IParser setSuppressNarratives(boolean var1);

    public IParser setDontStripVersionsFromReferencesAtPaths(String ... var1);

    public IParser setDontStripVersionsFromReferencesAtPaths(Collection<String> var1);

    public Set<String> getDontStripVersionsFromReferencesAtPaths();
}

