/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.i18n;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HapiLocalizer {
    public static final String UNKNOWN_I18N_KEY_MESSAGE = "!MESSAGE!";
    private static final Logger ourLog = LoggerFactory.getLogger(HapiLocalizer.class);
    private List<ResourceBundle> myBundle = new ArrayList<ResourceBundle>();
    private final Map<String, MessageFormat> myKeyToMessageFormat = new ConcurrentHashMap<String, MessageFormat>();
    private String[] myBundleNames;

    public HapiLocalizer() {
        this(HapiLocalizer.class.getPackage().getName() + ".hapi-messages");
    }

    public HapiLocalizer(String ... theBundleNames) {
        this.myBundleNames = theBundleNames;
        this.init();
    }

    protected void init() {
        for (String nextName : this.myBundleNames) {
            this.myBundle.add(ResourceBundle.getBundle(nextName));
        }
    }

    private String findFormatString(String theQualifiedKey) {
        String formatString = null;
        for (ResourceBundle nextBundle : this.myBundle) {
            if (nextBundle.containsKey(theQualifiedKey)) {
                formatString = nextBundle.getString(theQualifiedKey);
            }
            if (!StringUtils.isNotBlank((CharSequence)formatString)) continue;
            break;
        }
        if (formatString == null) {
            ourLog.warn("Unknown localization key: {}", (Object)theQualifiedKey);
            formatString = UNKNOWN_I18N_KEY_MESSAGE;
        }
        return formatString;
    }

    public String getMessage(Class<?> theType, String theKey, Object ... theParameters) {
        return this.getMessage(theType.getName() + '.' + theKey, theParameters);
    }

    public String getMessage(String theQualifiedKey, Object ... theParameters) {
        if (theParameters != null && theParameters.length > 0) {
            MessageFormat format = this.myKeyToMessageFormat.get(theQualifiedKey);
            if (format != null) {
                return format.format(theParameters).toString();
            }
            String formatString = this.findFormatString(theQualifiedKey);
            format = new MessageFormat(formatString.trim());
            this.myKeyToMessageFormat.put(theQualifiedKey, format);
            return format.format(theParameters).toString();
        }
        String retVal = this.findFormatString(theQualifiedKey);
        return retVal;
    }
}

