/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.rest.method.RestSearchParameterTypeEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class RuntimeSearchParam {
    private final List<RuntimeSearchParam> myCompositeOf;
    private final String myDescription;
    private final String myName;
    private final RestSearchParameterTypeEnum myParamType;
    private final String myPath;
    private final Set<String> myTargets;
    private final Set<String> myProvidesMembershipInCompartments;

    public RuntimeSearchParam(String theName, String theDescription, String thePath, RestSearchParameterTypeEnum theParamType, List<RuntimeSearchParam> theCompositeOf, Set<String> theProvidesMembershipInCompartments, Set<String> theTargets) {
        this.myName = theName;
        this.myDescription = theDescription;
        this.myPath = thePath;
        this.myParamType = theParamType;
        this.myCompositeOf = theCompositeOf;
        this.myProvidesMembershipInCompartments = theProvidesMembershipInCompartments != null && !theProvidesMembershipInCompartments.isEmpty() ? Collections.unmodifiableSet(theProvidesMembershipInCompartments) : null;
        this.myTargets = theTargets != null && !theTargets.isEmpty() ? Collections.unmodifiableSet(theTargets) : null;
    }

    public Set<String> getTargets() {
        return this.myTargets;
    }

    public RuntimeSearchParam(String theName, String theDescription, String thePath, RestSearchParameterTypeEnum theParamType, Set<String> theProvidesMembershipInCompartments, Set<String> theTargets) {
        this(theName, theDescription, thePath, theParamType, null, theProvidesMembershipInCompartments, theTargets);
    }

    public List<RuntimeSearchParam> getCompositeOf() {
        return this.myCompositeOf;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getName() {
        return this.myName;
    }

    public RestSearchParameterTypeEnum getParamType() {
        return this.myParamType;
    }

    public String getPath() {
        return this.myPath;
    }

    public List<String> getPathsSplit() {
        String path = this.getPath();
        if (path.indexOf(124) == -1) {
            return Collections.singletonList(path);
        }
        ArrayList<String> retVal = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(path, "|");
        while (tok.hasMoreElements()) {
            String nextPath = tok.nextToken().trim();
            retVal.add(nextPath.trim());
        }
        return retVal;
    }

    public Set<String> getProvidesMembershipInCompartments() {
        return this.myProvidesMembershipInCompartments;
    }
}

