/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;

public enum FhirVersionEnum {
    DSTU1("ca.uhn.fhir.model.dstu.FhirDstu1", null, false, "0.0.82"),
    DSTU2("ca.uhn.fhir.model.dstu2.FhirDstu2", null, false, "1.0.2"),
    DSTU2_HL7ORG("org.hl7.fhir.instance.FhirDstu2Hl7Org", DSTU2, true, "1.0.2"),
    DSTU2_1("NONE", null, true, "1.4.0"),
    DSTU3("org.hl7.fhir.dstu3.hapi.ctx.FhirDstu3", null, true, "1.6.0");

    private final FhirVersionEnum myEquivalent;
    private final String myFhirVersionString;
    private final boolean myIsRi;
    private volatile Boolean myPresentOnClasspath;
    private final String myVersionClass;
    private volatile IFhirVersion myVersionImplementation;

    private FhirVersionEnum(String theVersionClass, FhirVersionEnum theEquivalent, boolean theIsRi, String theFhirVersion) {
        this.myVersionClass = theVersionClass;
        this.myEquivalent = theEquivalent;
        this.myIsRi = theIsRi;
        this.myFhirVersionString = theFhirVersion;
    }

    public String getFhirVersionString() {
        return this.myFhirVersionString;
    }

    public IFhirVersion getVersionImplementation() {
        if (!this.isPresentOnClasspath()) {
            throw new IllegalStateException("Version " + this.name() + " is not present on classpath");
        }
        if (this.myVersionImplementation == null) {
            try {
                this.myVersionImplementation = (IFhirVersion)Class.forName(this.myVersionClass).newInstance();
            }
            catch (Exception e) {
                throw new InternalErrorException("Failed to instantiate FHIR version " + this.name(), (Throwable)e);
            }
        }
        return this.myVersionImplementation;
    }

    public boolean isEquivalentTo(FhirVersionEnum theVersion) {
        if (this.equals((Object)theVersion)) {
            return true;
        }
        if (this.myEquivalent != null) {
            return this.myEquivalent.equals((Object)theVersion);
        }
        return false;
    }

    public boolean isNewerThan(FhirVersionEnum theVersion) {
        return this.ordinal() > theVersion.ordinal();
    }

    public boolean isOlderThan(FhirVersionEnum theVersion) {
        return this.ordinal() < theVersion.ordinal();
    }

    public boolean isPresentOnClasspath() {
        Boolean retVal = this.myPresentOnClasspath;
        if (retVal == null) {
            try {
                Class.forName(this.myVersionClass);
                retVal = true;
            }
            catch (Exception e) {
                retVal = false;
            }
            this.myPresentOnClasspath = retVal;
        }
        return retVal;
    }

    public boolean isRi() {
        return this.myIsRi;
    }
}

