/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.AbstractInvocationHandler;
import com.lambdaworks.redis.RedisConnectionPool;
import com.lambdaworks.redis.RedisException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class PooledConnectionInvocationHandler<T>
extends AbstractInvocationHandler {
    private T connection;
    private final RedisConnectionPool<T> pool;
    private final LoadingCache<Method, Method> methodCache;

    public PooledConnectionInvocationHandler(final T connection, RedisConnectionPool<T> pool) {
        this.connection = connection;
        this.pool = pool;
        this.methodCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Method, Method>(){

            public Method load(Method key) throws Exception {
                return connection.getClass().getMethod(key.getName(), key.getParameterTypes());
            }
        });
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.connection == null) {
            throw new RedisException("Connection is deallocated and cannot be used anymore.");
        }
        if (method.getName().equals("close")) {
            this.pool.freeConnection(proxy);
            return null;
        }
        Method targetMethod = (Method)this.methodCache.get((Object)method);
        try {
            return targetMethod.invoke(this.connection, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public T getConnection() {
        return this.connection;
    }
}

