/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class RxJava2AdapterRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`RxJava2AdapterRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `RxJava2Adapter` [Source](https://error-prone.picnic.tech/refasterrules/RxJava2AdapterRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new CompletableToMonoRecipe()});
    }

    @NullMarked
    public static class CompletableToMonoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.CompletableToMono`";
        }

        public String getDescription() {
            return "Use the fluent API style when using `RxJava2Adapter#completableToMono`";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.completableToMono(#{completable:any(io.reactivex.Completable)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{completable:any(io.reactivex.Completable)}.to(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{completable:any(io.reactivex.Completable)}.as(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Completable", Boolean.valueOf(true)), new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Completable to(..)", true), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter completableToMono(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }
}

