/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the operation <code>DescribeDBMajorEngineVersions</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBMajorEngineVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<DBMajorEngineVersion.Builder, DBMajorEngineVersion> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DBMajorEngineVersion::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorEngineVersion").getter(getter(DBMajorEngineVersion::majorEngineVersion))
            .setter(setter(Builder::majorEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build())
            .build();

    private static final SdkField<List<SupportedEngineLifecycle>> SUPPORTED_ENGINE_LIFECYCLES_FIELD = SdkField
            .<List<SupportedEngineLifecycle>> builder(MarshallingType.LIST)
            .memberName("SupportedEngineLifecycles")
            .getter(getter(DBMajorEngineVersion::supportedEngineLifecycles))
            .setter(setter(Builder::supportedEngineLifecycles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngineLifecycles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SupportedEngineLifecycle")
                            .memberFieldInfo(
                                    SdkField.<SupportedEngineLifecycle> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedEngineLifecycle::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SupportedEngineLifecycle").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            MAJOR_ENGINE_VERSION_FIELD, SUPPORTED_ENGINE_LIFECYCLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String engine;

    private final String majorEngineVersion;

    private final List<SupportedEngineLifecycle> supportedEngineLifecycles;

    private DBMajorEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.supportedEngineLifecycles = builder.supportedEngineLifecycles;
    }

    /**
     * <p>
     * The name of the database engine.
     * </p>
     * 
     * @return The name of the database engine.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The major version number of the database engine.
     * </p>
     * 
     * @return The major version number of the database engine.
     */
    public final String majorEngineVersion() {
        return majorEngineVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedEngineLifecycles property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedEngineLifecycles() {
        return supportedEngineLifecycles != null && !(supportedEngineLifecycles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the lifecycles supported by this engine for the <code>DescribeDBMajorEngineVersions</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedEngineLifecycles} method.
     * </p>
     * 
     * @return A list of the lifecycles supported by this engine for the <code>DescribeDBMajorEngineVersions</code>
     *         operation.
     */
    public final List<SupportedEngineLifecycle> supportedEngineLifecycles() {
        return supportedEngineLifecycles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedEngineLifecycles() ? supportedEngineLifecycles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBMajorEngineVersion)) {
            return false;
        }
        DBMajorEngineVersion other = (DBMajorEngineVersion) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(majorEngineVersion(), other.majorEngineVersion())
                && hasSupportedEngineLifecycles() == other.hasSupportedEngineLifecycles()
                && Objects.equals(supportedEngineLifecycles(), other.supportedEngineLifecycles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBMajorEngineVersion").add("Engine", engine()).add("MajorEngineVersion", majorEngineVersion())
                .add("SupportedEngineLifecycles", hasSupportedEngineLifecycles() ? supportedEngineLifecycles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "MajorEngineVersion":
            return Optional.ofNullable(clazz.cast(majorEngineVersion()));
        case "SupportedEngineLifecycles":
            return Optional.ofNullable(clazz.cast(supportedEngineLifecycles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Engine", ENGINE_FIELD);
        map.put("MajorEngineVersion", MAJOR_ENGINE_VERSION_FIELD);
        map.put("SupportedEngineLifecycles", SUPPORTED_ENGINE_LIFECYCLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBMajorEngineVersion, T> g) {
        return obj -> g.apply((DBMajorEngineVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBMajorEngineVersion> {
        /**
         * <p>
         * The name of the database engine.
         * </p>
         * 
         * @param engine
         *        The name of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The major version number of the database engine.
         * </p>
         * 
         * @param majorEngineVersion
         *        The major version number of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorEngineVersion(String majorEngineVersion);

        /**
         * <p>
         * A list of the lifecycles supported by this engine for the <code>DescribeDBMajorEngineVersions</code>
         * operation.
         * </p>
         * 
         * @param supportedEngineLifecycles
         *        A list of the lifecycles supported by this engine for the <code>DescribeDBMajorEngineVersions</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngineLifecycles(Collection<SupportedEngineLifecycle> supportedEngineLifecycles);

        /**
         * <p>
         * A list of the lifecycles supported by this engine for the <code>DescribeDBMajorEngineVersions</code>
         * operation.
         * </p>
         * 
         * @param supportedEngineLifecycles
         *        A list of the lifecycles supported by this engine for the <code>DescribeDBMajorEngineVersions</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngineLifecycles(SupportedEngineLifecycle... supportedEngineLifecycles);

        /**
         * <p>
         * A list of the lifecycles supported by this engine for the <code>DescribeDBMajorEngineVersions</code>
         * operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.SupportedEngineLifecycle.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rds.model.SupportedEngineLifecycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.SupportedEngineLifecycle.Builder#build()} is called
         * immediately and its result is passed to {@link #supportedEngineLifecycles(List<SupportedEngineLifecycle>)}.
         * 
         * @param supportedEngineLifecycles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.SupportedEngineLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedEngineLifecycles(java.util.Collection<SupportedEngineLifecycle>)
         */
        Builder supportedEngineLifecycles(Consumer<SupportedEngineLifecycle.Builder>... supportedEngineLifecycles);
    }

    static final class BuilderImpl implements Builder {
        private String engine;

        private String majorEngineVersion;

        private List<SupportedEngineLifecycle> supportedEngineLifecycles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBMajorEngineVersion model) {
            engine(model.engine);
            majorEngineVersion(model.majorEngineVersion);
            supportedEngineLifecycles(model.supportedEngineLifecycles);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMajorEngineVersion() {
            return majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final List<SupportedEngineLifecycle.Builder> getSupportedEngineLifecycles() {
            List<SupportedEngineLifecycle.Builder> result = SupportedEngineLifecycleListCopier
                    .copyToBuilder(this.supportedEngineLifecycles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedEngineLifecycles(Collection<SupportedEngineLifecycle.BuilderImpl> supportedEngineLifecycles) {
            this.supportedEngineLifecycles = SupportedEngineLifecycleListCopier.copyFromBuilder(supportedEngineLifecycles);
        }

        @Override
        public final Builder supportedEngineLifecycles(Collection<SupportedEngineLifecycle> supportedEngineLifecycles) {
            this.supportedEngineLifecycles = SupportedEngineLifecycleListCopier.copy(supportedEngineLifecycles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineLifecycles(SupportedEngineLifecycle... supportedEngineLifecycles) {
            supportedEngineLifecycles(Arrays.asList(supportedEngineLifecycles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineLifecycles(Consumer<SupportedEngineLifecycle.Builder>... supportedEngineLifecycles) {
            supportedEngineLifecycles(Stream.of(supportedEngineLifecycles)
                    .map(c -> SupportedEngineLifecycle.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DBMajorEngineVersion build() {
            return new DBMajorEngineVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
