/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTenantDatabaseRequest extends RdsRequest implements
        ToCopyableBuilder<CreateTenantDatabaseRequest.Builder, CreateTenantDatabaseRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(CreateTenantDatabaseRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> TENANT_DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantDBName").getter(getter(CreateTenantDatabaseRequest::tenantDBName))
            .setter(setter(Builder::tenantDBName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDBName").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(CreateTenantDatabaseRequest::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(CreateTenantDatabaseRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(CreateTenantDatabaseRequest::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> NCHAR_CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NcharCharacterSetName").getter(getter(CreateTenantDatabaseRequest::ncharCharacterSetName))
            .setter(setter(Builder::ncharCharacterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NcharCharacterSetName").build())
            .build();

    private static final SdkField<Boolean> MANAGE_MASTER_USER_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ManageMasterUserPassword")
            .getter(getter(CreateTenantDatabaseRequest::manageMasterUserPassword))
            .setter(setter(Builder::manageMasterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterUserPassword").build())
            .build();

    private static final SdkField<String> MASTER_USER_SECRET_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserSecretKmsKeyId").getter(getter(CreateTenantDatabaseRequest::masterUserSecretKmsKeyId))
            .setter(setter(Builder::masterUserSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserSecretKmsKeyId").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTenantDatabaseRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            TENANT_DB_NAME_FIELD, MASTER_USERNAME_FIELD, MASTER_USER_PASSWORD_FIELD, CHARACTER_SET_NAME_FIELD,
            NCHAR_CHARACTER_SET_NAME_FIELD, MANAGE_MASTER_USER_PASSWORD_FIELD, MASTER_USER_SECRET_KMS_KEY_ID_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbInstanceIdentifier;

    private final String tenantDBName;

    private final String masterUsername;

    private final String masterUserPassword;

    private final String characterSetName;

    private final String ncharCharacterSetName;

    private final Boolean manageMasterUserPassword;

    private final String masterUserSecretKmsKeyId;

    private final List<Tag> tags;

    private CreateTenantDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.tenantDBName = builder.tenantDBName;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.characterSetName = builder.characterSetName;
        this.ncharCharacterSetName = builder.ncharCharacterSetName;
        this.manageMasterUserPassword = builder.manageMasterUserPassword;
        this.masterUserSecretKmsKeyId = builder.masterUserSecretKmsKeyId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The user-supplied DB instance identifier. RDS creates your tenant database in this DB instance. This parameter
     * isn't case-sensitive.
     * </p>
     * 
     * @return The user-supplied DB instance identifier. RDS creates your tenant database in this DB instance. This
     *         parameter isn't case-sensitive.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The user-supplied name of the tenant database that you want to create in your DB instance. This parameter has the
     * same constraints as <code>DBName</code> in <code>CreateDBInstance</code>.
     * </p>
     * 
     * @return The user-supplied name of the tenant database that you want to create in your DB instance. This parameter
     *         has the same constraints as <code>DBName</code> in <code>CreateDBInstance</code>.
     */
    public final String tenantDBName() {
        return tenantDBName;
    }

    /**
     * <p>
     * The name for the master user account in your tenant database. RDS creates this user account in the tenant
     * database and grants privileges to the master user. This parameter is case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 16 letters, numbers, or underscores.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be a reserved word for the chosen database engine.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for the master user account in your tenant database. RDS creates this user account in the tenant
     *         database and grants privileges to the master user. This parameter is case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 16 letters, numbers, or underscores.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be a reserved word for the chosen database engine.
     *         </p>
     *         </li>
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The password for the master user in your tenant database.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 8 to 30 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can include any printable ASCII character except forward slash (<code>/</code>), double quote (<code>"</code>),
     * at symbol (<code>@</code>), ampersand (<code>&amp;</code>), or single quote (<code>'</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be specified when <code>ManageMasterUserPassword</code> is enabled.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The password for the master user in your tenant database.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 8 to 30 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can include any printable ASCII character except forward slash (<code>/</code>), double quote (
     *         <code>"</code>), at symbol (<code>@</code>), ampersand (<code>&amp;</code>), or single quote (
     *         <code>'</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be specified when <code>ManageMasterUserPassword</code> is enabled.
     *         </p>
     *         </li>
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The character set for your tenant database. If you don't specify a value, the character set name defaults to
     * <code>AL32UTF8</code>.
     * </p>
     * 
     * @return The character set for your tenant database. If you don't specify a value, the character set name defaults
     *         to <code>AL32UTF8</code>.
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * The <code>NCHAR</code> value for the tenant database.
     * </p>
     * 
     * @return The <code>NCHAR</code> value for the tenant database.
     */
    public final String ncharCharacterSetName() {
        return ncharCharacterSetName;
    }

    /**
     * <p>
     * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with
     * Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't manage the master user password with Amazon Web Services Secrets Manager if <code>MasterUserPassword</code>
     * is specified.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
     *         management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't manage the master user password with Amazon Web Services Secrets Manager if
     *         <code>MasterUserPassword</code> is specified.
     *         </p>
     *         </li>
     */
    public final Boolean manageMasterUserPassword() {
        return manageMasterUserPassword;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
     * Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager
     * for the DB instance.
     * </p>
     * <p>
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To
     * use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * </p>
     * <p>
     * If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is
     * used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the
     * <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.
     * </p>
     * <p>
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
     * default KMS key for each Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
     *         managed in Amazon Web Services Secrets Manager.</p>
     *         <p>
     *         This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
     *         Manager for the DB instance.
     *         </p>
     *         <p>
     *         The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS
     *         key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS
     *         key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you
     *         can't use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer
     *         managed KMS key.
     *         </p>
     *         <p>
     *         There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
     *         different default KMS key for each Amazon Web Services Region.
     */
    public final String masterUserSecretKmsKeyId() {
        return masterUserSecretKmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDBName());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(ncharCharacterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(manageMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTenantDatabaseRequest)) {
            return false;
        }
        CreateTenantDatabaseRequest other = (CreateTenantDatabaseRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(tenantDBName(), other.tenantDBName())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(ncharCharacterSetName(), other.ncharCharacterSetName())
                && Objects.equals(manageMasterUserPassword(), other.manageMasterUserPassword())
                && Objects.equals(masterUserSecretKmsKeyId(), other.masterUserSecretKmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTenantDatabaseRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("TenantDBName", tenantDBName()).add("MasterUsername", masterUsername())
                .add("MasterUserPassword", masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CharacterSetName", characterSetName()).add("NcharCharacterSetName", ncharCharacterSetName())
                .add("ManageMasterUserPassword", manageMasterUserPassword())
                .add("MasterUserSecretKmsKeyId", masterUserSecretKmsKeyId()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "TenantDBName":
            return Optional.ofNullable(clazz.cast(tenantDBName()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "NcharCharacterSetName":
            return Optional.ofNullable(clazz.cast(ncharCharacterSetName()));
        case "ManageMasterUserPassword":
            return Optional.ofNullable(clazz.cast(manageMasterUserPassword()));
        case "MasterUserSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(masterUserSecretKmsKeyId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("TenantDBName", TENANT_DB_NAME_FIELD);
        map.put("MasterUsername", MASTER_USERNAME_FIELD);
        map.put("MasterUserPassword", MASTER_USER_PASSWORD_FIELD);
        map.put("CharacterSetName", CHARACTER_SET_NAME_FIELD);
        map.put("NcharCharacterSetName", NCHAR_CHARACTER_SET_NAME_FIELD);
        map.put("ManageMasterUserPassword", MANAGE_MASTER_USER_PASSWORD_FIELD);
        map.put("MasterUserSecretKmsKeyId", MASTER_USER_SECRET_KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTenantDatabaseRequest, T> g) {
        return obj -> g.apply((CreateTenantDatabaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTenantDatabaseRequest> {
        /**
         * <p>
         * The user-supplied DB instance identifier. RDS creates your tenant database in this DB instance. This
         * parameter isn't case-sensitive.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The user-supplied DB instance identifier. RDS creates your tenant database in this DB instance. This
         *        parameter isn't case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The user-supplied name of the tenant database that you want to create in your DB instance. This parameter has
         * the same constraints as <code>DBName</code> in <code>CreateDBInstance</code>.
         * </p>
         * 
         * @param tenantDBName
         *        The user-supplied name of the tenant database that you want to create in your DB instance. This
         *        parameter has the same constraints as <code>DBName</code> in <code>CreateDBInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDBName(String tenantDBName);

        /**
         * <p>
         * The name for the master user account in your tenant database. RDS creates this user account in the tenant
         * database and grants privileges to the master user. This parameter is case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 16 letters, numbers, or underscores.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be a reserved word for the chosen database engine.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUsername
         *        The name for the master user account in your tenant database. RDS creates this user account in the
         *        tenant database and grants privileges to the master user. This parameter is case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 16 letters, numbers, or underscores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be a reserved word for the chosen database engine.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The password for the master user in your tenant database.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 8 to 30 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can include any printable ASCII character except forward slash (<code>/</code>), double quote (<code>"</code>
         * ), at symbol (<code>@</code>), ampersand (<code>&amp;</code>), or single quote (<code>'</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be specified when <code>ManageMasterUserPassword</code> is enabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUserPassword
         *        The password for the master user in your tenant database.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 8 to 30 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can include any printable ASCII character except forward slash (<code>/</code>), double quote (
         *        <code>"</code>), at symbol (<code>@</code>), ampersand (<code>&amp;</code>), or single quote (
         *        <code>'</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be specified when <code>ManageMasterUserPassword</code> is enabled.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The character set for your tenant database. If you don't specify a value, the character set name defaults to
         * <code>AL32UTF8</code>.
         * </p>
         * 
         * @param characterSetName
         *        The character set for your tenant database. If you don't specify a value, the character set name
         *        defaults to <code>AL32UTF8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * The <code>NCHAR</code> value for the tenant database.
         * </p>
         * 
         * @param ncharCharacterSetName
         *        The <code>NCHAR</code> value for the tenant database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ncharCharacterSetName(String ncharCharacterSetName);

        /**
         * <p>
         * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management
         * with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't manage the master user password with Amazon Web Services Secrets Manager if
         * <code>MasterUserPassword</code> is specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param manageMasterUserPassword
         *        Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password
         *        management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't manage the master user password with Amazon Web Services Secrets Manager if
         *        <code>MasterUserPassword</code> is specified.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageMasterUserPassword(Boolean manageMasterUserPassword);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in
         * Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets
         * Manager for the DB instance.
         * </p>
         * <p>
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * </p>
         * <p>
         * If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key
         * is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't
         * use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed
         * KMS key.
         * </p>
         * <p>
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
         * different default KMS key for each Amazon Web Services Region.
         * </p>
         * 
         * @param masterUserSecretKmsKeyId
         *        The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and
         *        managed in Amazon Web Services Secrets Manager.</p>
         *        <p>
         *        This setting is valid only if the master user password is managed by RDS in Amazon Web Services
         *        Secrets Manager for the DB instance.
         *        </p>
         *        <p>
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias
         *        ARN.
         *        </p>
         *        <p>
         *        If you don't specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code>
         *        KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account,
         *        then you can't use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use
         *        a customer managed KMS key.
         *        </p>
         *        <p>
         *        There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has
         *        a different default KMS key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String tenantDBName;

        private String masterUsername;

        private String masterUserPassword;

        private String characterSetName;

        private String ncharCharacterSetName;

        private Boolean manageMasterUserPassword;

        private String masterUserSecretKmsKeyId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTenantDatabaseRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            tenantDBName(model.tenantDBName);
            masterUsername(model.masterUsername);
            masterUserPassword(model.masterUserPassword);
            characterSetName(model.characterSetName);
            ncharCharacterSetName(model.ncharCharacterSetName);
            manageMasterUserPassword(model.manageMasterUserPassword);
            masterUserSecretKmsKeyId(model.masterUserSecretKmsKeyId);
            tags(model.tags);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getTenantDBName() {
            return tenantDBName;
        }

        public final void setTenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
        }

        @Override
        public final Builder tenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getNcharCharacterSetName() {
            return ncharCharacterSetName;
        }

        public final void setNcharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
        }

        @Override
        public final Builder ncharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
            return this;
        }

        public final Boolean getManageMasterUserPassword() {
            return manageMasterUserPassword;
        }

        public final void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
        }

        @Override
        public final Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        public final String getMasterUserSecretKmsKeyId() {
            return masterUserSecretKmsKeyId;
        }

        public final void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
        }

        @Override
        public final Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTenantDatabaseRequest build() {
            return new CreateTenantDatabaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
