/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.extensions.manager.standalone.ExtensionsStandaloneManagerFactory;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAware;
import ro.isdc.wro.maven.plugin.support.BuildContextHolder;
import ro.isdc.wro.maven.plugin.support.ExtraConfigFileAware;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.decorator.ExceptionHandlingProcessorDecorator;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.util.Function;
import ro.isdc.wro.util.concurrent.TaskExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWro4jMojo
extends AbstractMojo {
    private File wroFile;
    private File contextFolder;
    private boolean minimize;
    private boolean ignoreMissingResources;
    private String targetGroups;
    private MavenProject mavenProject;
    private String wroManagerFactory;
    private WroManagerFactory managerFactory;
    private File extraConfigFile;
    private BuildContext buildContext;
    private File buildDirectory;
    private BuildContextHolder buildContextHolder;
    private boolean parallelProcessing;
    private boolean incrementalBuildEnabled;
    private TaskExecutor<Void> taskExecutor;

    public final void execute() throws MojoExecutionException {
        this.validate();
        this.getLog().info((CharSequence)"Executing the mojo: ");
        this.getLog().info((CharSequence)("Wro4j Model path: " + this.wroFile.getPath()));
        this.getLog().info((CharSequence)("targetGroups: " + this.getTargetGroups()));
        this.getLog().info((CharSequence)("minimize: " + this.isMinimize()));
        this.getLog().info((CharSequence)("ignoreMissingResources: " + this.isIgnoreMissingResources()));
        this.getLog().info((CharSequence)("parallelProcessing: " + this.isParallelProcessing()));
        this.getLog().debug((CharSequence)("wroManagerFactory: " + this.wroManagerFactory));
        this.getLog().debug((CharSequence)("incrementalBuildEnabled: " + this.incrementalBuildEnabled));
        this.getLog().debug((CharSequence)("extraConfig: " + this.extraConfigFile));
        this.extendPluginClasspath();
        Context.set((Context)Context.standaloneContext());
        try {
            this.onBeforeExecute();
            this.doExecute();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Exception occured while executing maven plugin", (Throwable)e);
            String message = "Exception occured while processing: " + e.toString() + ", class: " + e.getClass().getName() + ",caused by: " + (e.getCause() != null ? e.getCause().getClass().getName() : "");
            this.getLog().error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, e);
        }
        finally {
            try {
                this.onAfterExecute();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Exception in onAfterExecute", e);
            }
        }
    }

    protected void onBeforeExecute() {
    }

    protected void onAfterExecute() {
    }

    private StandaloneContext createStandaloneContext() {
        StandaloneContext runContext = new StandaloneContext();
        runContext.setContextFolder(this.getContextFolder());
        runContext.setMinimize(this.isMinimize());
        runContext.setWroFile(this.getWroFile());
        runContext.setIgnoreMissingResources(this.isIgnoreMissingResources());
        return runContext;
    }

    protected abstract void doExecute() throws Exception;

    protected WroManagerFactory getManagerFactory() {
        if (this.managerFactory == null) {
            WroManagerFactory localManagerFactory = null;
            try {
                localManagerFactory = this.newWroManagerFactory();
            }
            catch (MojoExecutionException e) {
                throw WroRuntimeException.wrap((Exception)((Object)e));
            }
            if (localManagerFactory instanceof StandaloneContextAware) {
                ((StandaloneContextAware)localManagerFactory).initialize(this.createStandaloneContext());
            }
            this.managerFactory = this.decorateManagerFactory(localManagerFactory);
        }
        return this.managerFactory;
    }

    protected WroManagerFactory decorateManagerFactory(WroManagerFactory managerFactory) {
        return managerFactory;
    }

    protected WroManagerFactory newWroManagerFactory() throws MojoExecutionException {
        Object factory = null;
        factory = this.wroManagerFactory != null ? this.createCustomManagerFactory() : new ExtensionsStandaloneManagerFactory();
        this.getLog().info((CharSequence)("wroManagerFactory class: " + factory.getClass().getName()));
        if (factory instanceof ExtraConfigFileAware) {
            if (this.extraConfigFile == null) {
                throw new MojoExecutionException("The " + factory.getClass() + " requires a valid extraConfigFile!");
            }
            this.getLog().debug((CharSequence)("Using extraConfigFile: " + this.extraConfigFile.getAbsolutePath()));
            ((ExtraConfigFileAware)factory).setExtraConfigFile(this.extraConfigFile);
        }
        return factory;
    }

    private WroManagerFactory createCustomManagerFactory() throws MojoExecutionException {
        WroManagerFactory managerFactory;
        try {
            Class<?> wroManagerFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(this.wroManagerFactory.trim());
            managerFactory = (WroManagerFactory)wroManagerFactoryClass.newInstance();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Cannot instantiate wroManagerFactoryClass", (Throwable)e);
            throw new MojoExecutionException("Invalid wroManagerFactoryClass, called: " + this.wroManagerFactory, e);
        }
        return managerFactory;
    }

    protected final List<String> getTargetGroupsAsList() throws Exception {
        List<String> result = null;
        result = this.isIncrementalCheckRequired() ? this.getIncrementalGroupNames() : (this.getTargetGroups() == null ? this.getAllModelGroupNames() : Arrays.asList(this.getTargetGroups().split(",")));
        this.persistResourceFingerprints(result);
        if (result.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to process (nothing configured or nothing changed since last build).");
        } else {
            this.getLog().info((CharSequence)("The following groups will be processed: " + result));
        }
        return result;
    }

    protected boolean isIncrementalCheckRequired() {
        return this.isIncrementalBuild();
    }

    private void persistResourceFingerprints(List<String> groupNames) {
        WroModelInspector modelInspector = new WroModelInspector(this.getModel());
        for (String groupName : groupNames) {
            Group group = modelInspector.getGroupByName(groupName);
            if (group == null) continue;
            for (Resource resource : group.getResources()) {
                this.persistResourceFingerprints(resource);
            }
        }
    }

    private void persistResourceFingerprints(Resource resource) {
        WroManager manager = this.getWroManager();
        HashStrategy hashStrategy = manager.getHashStrategy();
        UriLocatorFactory locatorFactory = manager.getUriLocatorFactory();
        try {
            String fingerprint = hashStrategy.getHash(locatorFactory.locate(resource.getUri()));
            this.getBuildContextHolder().setValue(resource.getUri(), fingerprint);
            this.getLog().debug((CharSequence)("Persist fingerprint for resource '" + resource.getUri() + "' : " + fingerprint));
            if (resource.getType() == ResourceType.CSS) {
                InputStreamReader reader = new InputStreamReader(locatorFactory.locate(resource.getUri()));
                this.getLog().debug((CharSequence)("Check @import directive from " + resource));
                this.persistFingerprintsForCssImports(resource, reader);
            }
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("could not check fingerprint of resource: " + resource));
        }
    }

    private void forEachCssImportApply(final Function<String, Void> func, Resource resource, Reader reader) throws IOException {
        AbstractCssImportPreProcessor cssImportProcessor = new AbstractCssImportPreProcessor(){

            protected void onImportDetected(String importedUri) {
                AbstractWro4jMojo.this.getLog().debug((CharSequence)("Found @import " + importedUri));
                try {
                    func.apply((Object)importedUri);
                }
                catch (Exception e) {
                    AbstractWro4jMojo.this.getLog().error((CharSequence)("Cannot apply a function on @import resource: " + importedUri + ". Ignoring it."), (Throwable)e);
                }
                AbstractWro4jMojo.this.persistResourceFingerprints(Resource.create((String)importedUri, (ResourceType)ResourceType.CSS));
            }

            protected String doTransform(String cssContent, List<Resource> foundImports) throws IOException {
                return "";
            }

            public String toString() {
                return CssImportPreProcessor.class.getSimpleName();
            }
        };
        ExceptionHandlingProcessorDecorator processor = new ExceptionHandlingProcessorDecorator(cssImportProcessor){

            protected boolean isIgnoreFailingProcessor() {
                return true;
            }
        };
        InjectorBuilder.create((WroManagerFactory)this.getManagerFactory()).build().inject((Object)processor);
        processor.process(resource, reader, (Writer)new StringWriter());
    }

    private void persistFingerprintsForCssImports(Resource resource, Reader reader) throws IOException {
        this.forEachCssImportApply(new Function<String, Void>(){

            public Void apply(String importedUri) throws Exception {
                AbstractWro4jMojo.this.persistResourceFingerprints(Resource.create((String)importedUri, (ResourceType)ResourceType.CSS));
                return null;
            }
        }, resource, reader);
    }

    private void detectChangeForCssImports(Resource resource, Reader reader, final AtomicBoolean changeDetected) throws IOException {
        this.forEachCssImportApply(new Function<String, Void>(){

            public Void apply(String importedUri) throws Exception {
                boolean isImportChanged = AbstractWro4jMojo.this.isResourceChanged(Resource.create((String)importedUri, (ResourceType)ResourceType.CSS));
                AbstractWro4jMojo.this.getLog().debug((CharSequence)("\tisImportChanged: " + isImportChanged));
                if (isImportChanged) {
                    changeDetected.set(true);
                    throw new WroRuntimeException("Change detected. No need to continue processing");
                }
                return null;
            }
        }, resource, reader);
    }

    private List<String> getIncrementalGroupNames() throws Exception {
        ArrayList<String> changedGroupNames = new ArrayList<String>();
        block0: for (Group group : this.getModel().getGroups()) {
            if (!this.isTargetGroup(group)) continue;
            for (Resource resource : group.getResources()) {
                this.getLog().debug((CharSequence)("checking delta for resource: " + resource));
                if (!this.isResourceChanged(resource)) continue;
                this.getLog().debug((CharSequence)("detected change for resource: " + resource + " and group: " + group.getName()));
                changedGroupNames.add(group.getName());
                continue block0;
            }
        }
        return changedGroupNames;
    }

    private boolean isTargetGroup(Group group) {
        Validate.notNull((Object)group);
        String targetGroups = this.getTargetGroups();
        return targetGroups == null || targetGroups.contains(group.getName());
    }

    private boolean isResourceChanged(Resource resource) {
        WroManager manager = this.getWroManager();
        HashStrategy hashStrategy = manager.getHashStrategy();
        UriLocatorFactory locatorFactory = manager.getUriLocatorFactory();
        AtomicBoolean changeDetected = new AtomicBoolean(false);
        try {
            String fingerprint = hashStrategy.getHash(locatorFactory.locate(resource.getUri()));
            String previousFingerprint = this.getBuildContextHolder().getValue(resource.getUri());
            this.getLog().debug((CharSequence)("fingerprint <current, prev>: <" + fingerprint + ", " + previousFingerprint + ">"));
            changeDetected.set(fingerprint != null && !fingerprint.equals(previousFingerprint));
            if (!changeDetected.get() && resource.getType() == ResourceType.CSS) {
                InputStreamReader reader = new InputStreamReader(locatorFactory.locate(resource.getUri()));
                this.getLog().debug((CharSequence)("Check @import directive from " + resource));
                this.detectChangeForCssImports(resource, reader, changeDetected);
            }
            return changeDetected.get();
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("failed to check for delta resource: " + resource));
            return false;
        }
    }

    protected final boolean isIncrementalBuild() {
        return this.getBuildContextHolder().isIncrementalBuild();
    }

    private List<String> getAllModelGroupNames() {
        return new WroModelInspector(this.getModel()).getGroupNames();
    }

    private WroModel getModel() {
        return (WroModel)this.getWroManager().getModelFactory().create();
    }

    private WroManager getWroManager() {
        try {
            return (WroManager)this.getManagerFactory().create();
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap((Exception)e);
        }
    }

    protected void validate() throws MojoExecutionException {
        if (this.wroFile == null) {
            throw new MojoExecutionException("contextFolder was not set!");
        }
        if (this.contextFolder == null) {
            throw new MojoExecutionException("contextFolder was not set!");
        }
    }

    protected final void extendPluginClasspath() throws MojoExecutionException {
        ArrayList<String> classpathElements = new ArrayList<String>();
        try {
            classpathElements.addAll(this.mavenProject.getRuntimeClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not get compile classpath elements", (Exception)((Object)e));
        }
        ClassLoader classLoader = this.createClassLoader(classpathElements);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private ClassLoader createClassLoader(List<String> classpathElements) {
        this.getLog().debug((CharSequence)"Classpath elements:");
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String element : classpathElements) {
                File elementFile = new File(element);
                this.getLog().debug((CharSequence)("Adding element to plugin classpath: " + elementFile.getPath()));
                urls.add(elementFile.toURI().toURL());
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error retreiving URL for artifact", (Throwable)e);
            throw new RuntimeException(e);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    protected final TaskExecutor<Void> getTaskExecutor() {
        if (this.taskExecutor == null) {
            this.taskExecutor = new TaskExecutor<Void>(){

                protected void onException(Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return this.taskExecutor;
    }

    private BuildContextHolder getBuildContextHolder() {
        if (this.buildContextHolder == null) {
            this.buildContextHolder = new BuildContextHolder(this.buildContext, this.buildDirectory);
            this.buildContextHolder.setIncrementalBuildEnabled(this.incrementalBuildEnabled);
        }
        return this.buildContextHolder;
    }

    @VisibleForTesting
    void setTaskExecutor(TaskExecutor<Void> taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    void setContextFolder(File contextFolder) {
        this.contextFolder = contextFolder;
    }

    void setWroFile(File wroFile) {
        this.wroFile = wroFile;
    }

    File getWroFile() {
        return this.wroFile;
    }

    File getContextFolder() {
        return this.contextFolder;
    }

    void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }

    protected final boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    final void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    final void setIncrementalBuildEnabled(boolean incrementalBuildEnabled) {
        this.incrementalBuildEnabled = incrementalBuildEnabled;
    }

    boolean isMinimize() {
        return this.minimize;
    }

    boolean isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    String getTargetGroups() {
        return this.targetGroups;
    }

    void setTargetGroups(String targetGroups) {
        this.targetGroups = targetGroups;
    }

    void setWroManagerFactory(String wroManagerFactory) {
        this.wroManagerFactory = wroManagerFactory;
    }

    void setExtraConfigFile(File extraConfigFile) {
        this.extraConfigFile = extraConfigFile;
    }

    void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    void clean() {
        this.getBuildContextHolder().destroy();
    }
}

