/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.OutputStream;
import java.util.List;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.DelegatingServletOutputStream;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactoryDecorator;
import ro.isdc.wro.maven.plugin.AbstractWro4jMojo;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;
import ro.isdc.wro.util.io.NullOutputStream;

public abstract class AbstractSingleProcessorMojo
extends AbstractWro4jMojo {
    private String options;

    public final void doExecute() throws Exception {
        this.getLog().info((CharSequence)("options: " + this.options));
        List<String> groupsAsList = this.getTargetGroupsAsList();
        for (String group : groupsAsList) {
            for (ResourceType resourceType : ResourceType.values()) {
                String groupWithExtension = group + "." + resourceType.name().toLowerCase();
                this.processGroup(groupWithExtension);
            }
        }
    }

    private void processGroup(String group) throws Exception {
        this.getLog().info((CharSequence)("processing group: " + group));
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)group);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)new DelegatingServletOutputStream((OutputStream)new NullOutputStream()));
        WroConfiguration config = Context.get().getConfig();
        Context.set((Context)Context.webContext((HttpServletRequest)request, (HttpServletResponse)response, (FilterConfig)((FilterConfig)Mockito.mock(FilterConfig.class))), (WroConfiguration)config);
        ((WroManager)this.getManagerFactory().create()).process();
        this.getLog().debug((CharSequence)("Processing group: " + group + " [OK]"));
    }

    protected WroManagerFactory getManagerFactory() {
        return new WroManagerFactoryDecorator(super.getManagerFactory()){

            protected void onBeforeBuild(WroManager.Builder builder) {
                builder.setProcessorsFactory(AbstractSingleProcessorMojo.this.createSingleProcessorsFactory());
            }
        };
    }

    private ProcessorsFactory createSingleProcessorsFactory() {
        SimpleProcessorsFactory factory = new SimpleProcessorsFactory();
        ResourcePreProcessor processor = this.createResourceProcessor();
        factory.addPreProcessor(processor);
        return factory;
    }

    protected abstract ResourcePreProcessor createResourceProcessor();

    protected String getOptions() {
        return this.options;
    }

    void setOptions(String options) {
        this.options = options;
    }
}

