/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.Validate;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.locator.WebjarUriLocator;
import ro.isdc.wro.extensions.script.RhinoUtils;

public final class RhinoScriptBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RhinoScriptBuilder.class);
    private static final String SCRIPT_COMMONS = "commons.js";
    private static final String SCRIPT_ENVIRONMENT = "env.rhino.js";
    private static final String SCRIPT_JSON = "json2.min.js";
    private static final String SCRIPT_CYCLE = "cycle.js";
    private final ScriptableObject scope;

    private RhinoScriptBuilder() {
        this(null);
    }

    private RhinoScriptBuilder(ScriptableObject scope) {
        this.scope = this.createContext(scope);
    }

    private Context getContext() {
        this.initContext();
        return Context.getCurrentContext();
    }

    public ScriptableObject getScope() {
        return this.scope;
    }

    private ScriptableObject createContext(ScriptableObject initialScope) {
        Context context = this.getContext();
        context.setOptimizationLevel(-1);
        context.setErrorReporter((ErrorReporter)new ToolErrorReporter(false));
        context.setLanguageVersion(200);
        ScriptableObject scriptCommon = (ScriptableObject)context.initStandardObjects(initialScope);
        try (AutoCloseInputStream script = new AutoCloseInputStream(this.getClass().getResourceAsStream(SCRIPT_COMMONS));){
            context.evaluateReader((Scriptable)scriptCommon, (Reader)new InputStreamReader((InputStream)script), SCRIPT_COMMONS, 1, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem while evaluationg commons script.", e);
        }
        return scriptCommon;
    }

    public RhinoScriptBuilder addClientSideEnvironment() {
        try {
            InputStream scriptEnv = new WebjarUriLocator().locate(SCRIPT_ENVIRONMENT);
            this.evaluateChain(scriptEnv, SCRIPT_ENVIRONMENT);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize env.rhino script", e);
        }
    }

    public RhinoScriptBuilder addJSON() {
        try {
            AutoCloseInputStream script = new AutoCloseInputStream(new WebjarUriLocator().locate(WebjarUriLocator.createUri(SCRIPT_JSON)));
            InputStream scriptCycle = this.getClass().getResourceAsStream(SCRIPT_CYCLE);
            this.evaluateChain((InputStream)script, SCRIPT_JSON);
            this.evaluateChain(scriptCycle, SCRIPT_CYCLE);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize json2.min.js script", e);
        }
    }

    public RhinoScriptBuilder evaluateChain(InputStream stream, String sourceName) throws IOException {
        RhinoScriptBuilder rhinoScriptBuilder;
        block9: {
            Validate.notNull((Object)stream);
            InputStream inputStream = stream;
            try {
                this.getContext().evaluateReader((Scriptable)this.scope, (Reader)new InputStreamReader(stream), sourceName, 1, null);
                rhinoScriptBuilder = this;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RhinoException e) {
                    LOG.error("RhinoException: {}", (Object)RhinoUtils.createExceptionMessage(e));
                    throw e;
                }
                catch (RuntimeException e) {
                    LOG.error("Exception caught", (Throwable)e);
                    throw e;
                }
            }
            inputStream.close();
        }
        return rhinoScriptBuilder;
    }

    private void initContext() {
        if (Context.getCurrentContext() == null) {
            Context.enter();
        }
    }

    public RhinoScriptBuilder evaluateChain(String script, String sourceName) {
        Validate.notNull((Object)script);
        this.getContext().evaluateString((Scriptable)this.scope, script, sourceName, 1, null);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Reader reader, String sourceName) throws IOException {
        Validate.notNull((Object)reader);
        try {
            Object object = this.evaluate(IOUtils.toString((Reader)reader), sourceName);
            return object;
        }
        finally {
            reader.close();
        }
    }

    public Object evaluate(String script, String sourceName) {
        Validate.notNull((Object)script);
        try {
            Object object = this.getContext().evaluateString((Scriptable)this.scope, script, sourceName, 1, null);
            return object;
        }
        catch (RhinoException e) {
            String message = RhinoUtils.createExceptionMessage(e);
            LOG.error("JavaScriptException occured: {}", (Object)message);
            throw new WroRuntimeException(message);
        }
        finally {
            if (Context.getCurrentContext() != null) {
                Context.exit();
            }
        }
    }

    public static RhinoScriptBuilder newChain() {
        return new RhinoScriptBuilder();
    }

    public static RhinoScriptBuilder newChain(ScriptableObject scope) {
        return new RhinoScriptBuilder(scope);
    }

    public static RhinoScriptBuilder newClientSideAwareChain() {
        return new RhinoScriptBuilder().addClientSideEnvironment();
    }
}

