/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.support.lint;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintError;
import ro.isdc.wro.extensions.processor.support.linter.LinterError;
import ro.isdc.wro.extensions.support.lint.AbstractReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.LintItem;
import ro.isdc.wro.extensions.support.lint.LintItemAdapter;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.util.Function;

public class ReportXmlFormatter
extends AbstractReportXmlFormatter<LintItem> {
    private static final String ELEMENT_CHECKSTYLE = "checkstyle";
    private static final String ELEMENT_ERROR = "error";
    private static final String ATTR_COLUMN = "column";
    private static final String ATTR_MESSAGE = "message";
    private static final String ELEMENT_LINT = "lint";
    private static final String ELEMENT_ISSUE = "issue";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_REASON = "reason";
    private static final String ATTR_LINE = "line";
    private static final String ATTR_EVIDENCE = "evidence";
    private static final String ATTR_CHARACTER = "char";
    private static final String ATTR_SEVERITY = "severity";
    private static final String ELEMENT_CSSLINT = "csslint";
    private final FormatterType formatterType;

    public static ReportXmlFormatter create(LintReport<LintItem> lintReport, FormatterType formatterType) {
        return new ReportXmlFormatter(lintReport, formatterType);
    }

    public static ReportXmlFormatter createForLinterError(LintReport<LinterError> lintReport, FormatterType formatterType) {
        return ReportXmlFormatter.createInternal(lintReport, formatterType, new Function<LinterError, LintItem>(){

            public LintItem apply(LinterError input) throws Exception {
                return new LintItemAdapter(input);
            }
        });
    }

    public static ReportXmlFormatter createForCssLintError(LintReport<CssLintError> lintReport, FormatterType formatterType) {
        return ReportXmlFormatter.createInternal(lintReport, formatterType, new Function<CssLintError, LintItem>(){

            public LintItem apply(CssLintError input) throws Exception {
                return new LintItemAdapter(input);
            }
        });
    }

    private static <F> ReportXmlFormatter createInternal(LintReport<F> lintReport, FormatterType formatterType, Function<F, LintItem> adapter) {
        LintReport<LintItem> report = new LintReport<LintItem>();
        for (ResourceLintReport<F> item : lintReport.getReports()) {
            ArrayList<Object> lints = new ArrayList<Object>();
            for (F lint : item.getLints()) {
                try {
                    lints.add(adapter.apply(lint));
                }
                catch (Exception e) {
                    throw WroRuntimeException.wrap((Exception)e, (String)"Problem while adapting lint item");
                }
            }
            report.addReport(ResourceLintReport.create(item.getResourcePath(), lints));
        }
        return new ReportXmlFormatter(report, formatterType);
    }

    protected ReportXmlFormatter(LintReport<LintItem> lintReport, FormatterType type) {
        super(lintReport);
        Validate.notNull((Object)((Object)type));
        this.formatterType = type;
    }

    @Override
    protected void buildDocument() {
        Element rootElement = this.getDocument().createElement(this.getRootElementName());
        this.getDocument().appendChild(rootElement);
        for (ResourceLintReport<LintItem> resourceLintReport : this.getLintReport().getReports()) {
            rootElement.appendChild(this.createFileElement(resourceLintReport));
        }
    }

    private Node createFileElement(ResourceLintReport<LintItem> resourceErrors) {
        Element fileElement = this.getDocument().createElement(ELEMENT_FILE);
        fileElement.setAttribute(ATTR_NAME, resourceErrors.getResourcePath());
        for (LintItem error : resourceErrors.getLints()) {
            fileElement.appendChild(this.createIssueElement(error));
        }
        return fileElement;
    }

    private Node createIssueElement(LintItem error) {
        String severity;
        String reason;
        String line;
        String evidence;
        Element issueElement = this.getDocument().createElement(this.getIssueElementName());
        String column = String.valueOf(error.getColumn());
        if (StringUtils.isNotBlank((CharSequence)column)) {
            issueElement.setAttribute(this.getColumnAttributeName(), column);
        }
        if (StringUtils.isNotBlank((CharSequence)(evidence = error.getEvidence()))) {
            issueElement.setAttribute(ATTR_EVIDENCE, evidence);
        }
        if (StringUtils.isNotBlank((CharSequence)(line = String.valueOf(error.getLine())))) {
            issueElement.setAttribute(ATTR_LINE, line);
        }
        if (StringUtils.isNotBlank((CharSequence)(reason = error.getReason()))) {
            issueElement.setAttribute(this.getReasonAttributeName(), reason);
        }
        if (StringUtils.isNotBlank((CharSequence)(severity = error.getSeverity()))) {
            issueElement.setAttribute(ATTR_SEVERITY, severity);
        }
        return issueElement;
    }

    protected String getColumnAttributeName() {
        return this.formatterType == FormatterType.CHECKSTYLE ? ATTR_COLUMN : ATTR_CHARACTER;
    }

    protected String getReasonAttributeName() {
        return this.formatterType == FormatterType.CHECKSTYLE ? ATTR_MESSAGE : ATTR_REASON;
    }

    protected String getIssueElementName() {
        return this.formatterType == FormatterType.CHECKSTYLE ? ELEMENT_ERROR : ELEMENT_ISSUE;
    }

    protected String getRootElementName() {
        String result = ELEMENT_CHECKSTYLE;
        if (this.formatterType == FormatterType.LINT) {
            result = ELEMENT_LINT;
        } else if (this.formatterType == FormatterType.CSSLINT) {
            result = ELEMENT_CSSLINT;
        }
        return result;
    }

    public static enum FormatterType {
        LINT,
        CHECKSTYLE,
        CSSLINT;

    }
}

