/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util.concurrent;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutor.class);
    private CompletionService<T> completionService;
    private ExecutorService completionExecutor;

    private CompletionService<T> getCompletionService() {
        if (this.completionService == null) {
            this.completionService = new ExecutorCompletionService<T>(this.getExecutor());
        }
        return this.completionService;
    }

    private ExecutorService getExecutor() {
        if (this.completionExecutor == null) {
            this.completionExecutor = this.newExecutor();
        }
        return this.completionExecutor;
    }

    protected ExecutorService newExecutor() {
        try {
            ExecutorService executor = (ExecutorService)Class.forName("java.util.concurrent.ForkJoinPool").newInstance();
            LOG.debug("Using ForkJoinPool as task executor.");
            return executor;
        }
        catch (Exception e) {
            LOG.debug("ForkJoinPool class is not available, using default executor. ", (Throwable)e);
            return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }
    }

    public void submit(Collection<Callable<T>> callables) throws Exception {
        Validate.notNull(callables);
        StopWatch watch = new StopWatch();
        watch.start("init");
        long start = System.currentTimeMillis();
        AtomicLong totalTime = new AtomicLong();
        LOG.debug("running {} tasks", (Object)callables.size());
        if (callables.size() == 1) {
            T result = callables.iterator().next().call();
            this.onResultAvailable(result);
        } else {
            LOG.debug("Running tasks in parallel");
            watch.stop();
            watch.start("submit tasks");
            for (Callable<T> callable : callables) {
                this.getCompletionService().submit(this.decorate(callable, totalTime));
            }
            watch.stop();
            watch.start("consume results");
            for (int i = 0; i < callables.size(); ++i) {
                this.doConsumeResult();
            }
        }
        watch.stop();
        this.destroy();
        LOG.debug("Number of Tasks: {}", (Object)callables.size());
        long averageExecutionTime = callables.size() != 0 ? totalTime.longValue() / (long)callables.size() : 0L;
        LOG.debug("Average Execution Time: {}", (Object)averageExecutionTime);
        LOG.debug("Total Task Time: {}", (Object)totalTime);
        LOG.debug("Grand Total Execution Time: {}", (Object)(System.currentTimeMillis() - start));
        LOG.debug(watch.prettyPrint());
    }

    private Callable<T> decorate(final Callable<T> decorated, final AtomicLong totalTime) {
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                long begin = System.currentTimeMillis();
                try {
                    Object v = decorated.call();
                    return v;
                }
                finally {
                    long end = System.currentTimeMillis();
                    totalTime.addAndGet(end - begin);
                }
            }
        };
    }

    protected void onException(Exception e) throws Exception {
    }

    protected void onResultAvailable(T result) throws Exception {
    }

    private void doConsumeResult() throws Exception {
        try {
            T result = this.getCompletionService().take().get();
            this.onResultAvailable(result);
        }
        catch (Exception e) {
            this.onException(e);
            LOG.error("Exception while consuming result", (Throwable)e);
        }
    }

    public void destroy() {
        if (this.completionExecutor != null) {
            this.completionExecutor.shutdown();
        }
    }
}

