/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support.change;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ExceptionHandlingProcessorDecorator;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.support.change.ResourceChangeDetector;
import ro.isdc.wro.util.StopWatch;

public class ResourceWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceWatcher.class);
    @Inject
    private CacheStrategy<CacheKey, CacheValue> cacheStrategy;
    @Inject
    private WroModelFactory modelFactory;
    @Inject
    private UriLocatorFactory locatorFactory;
    @Inject
    private Injector injector;
    private ResourceChangeDetector changeDetector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(CacheKey cacheEntry) {
        Validate.notNull((Object)cacheEntry);
        LOG.debug("ResourceWatcher started...");
        StopWatch watch = new StopWatch();
        watch.start("detect changes");
        try {
            Group group = ((WroModel)this.modelFactory.create()).getGroupByName(cacheEntry.getGroupName());
            if (this.isGroupChanged(group.collectResourcesOfType(cacheEntry.getType()))) {
                this.onGroupChanged(cacheEntry);
            }
            this.changeDetector.reset();
        }
        catch (Exception e) {
            this.onException(e);
        }
        finally {
            watch.stop();
            LOG.debug("resource watcher info: {}", (Object)watch.prettyPrint());
        }
    }

    protected void onException(Exception e) {
        LOG.info("Could not check for resource changes because: {}", (Object)e.getMessage());
        LOG.debug("[FAIL] detecting resource change ", (Throwable)e);
    }

    private boolean isGroupChanged(Group group) {
        LOG.debug("Checking if group {} is changed..", (Object)group.getName());
        List<Resource> resources = group.getResources();
        boolean isChanged = false;
        for (Resource resource : resources) {
            isChanged = this.isChanged(resource, group.getName());
            if (!isChanged) continue;
            this.onResourceChanged(resource);
            break;
        }
        return isChanged;
    }

    void onResourceChanged(Resource resource) {
    }

    void onGroupChanged(CacheKey key) {
        LOG.debug("detected change for cacheKey: {}", (Object)key);
        this.cacheStrategy.put(key, null);
    }

    private boolean isChanged(Resource resource, String groupName) {
        LOG.debug("Check change for resource {}", (Object)resource.getUri());
        try {
            String uri = resource.getUri();
            AtomicBoolean changeDetected = new AtomicBoolean(this.getResourceChangeDetector().checkChangeForGroup(uri, groupName));
            if (!changeDetected.get() && resource.getType() == ResourceType.CSS) {
                InputStreamReader reader = new InputStreamReader(this.locatorFactory.locate(uri));
                LOG.debug("Check @import directive from {}", (Object)resource);
                this.createCssImportProcessor(changeDetected, groupName).process(resource, reader, new StringWriter());
            }
            return changeDetected.get();
        }
        catch (IOException e) {
            LOG.debug("[FAIL] Cannot check {} resource (Exception message: {}). Assuming it is unchanged...", (Object)resource, (Object)e.getMessage());
            return false;
        }
    }

    private ResourcePreProcessor createCssImportProcessor(final AtomicBoolean changeDetected, final String groupName) {
        AbstractCssImportPreProcessor cssImportProcessor = new AbstractCssImportPreProcessor(){

            @Override
            protected void onImportDetected(String importedUri) {
                LOG.debug("Found @import {}", (Object)importedUri);
                boolean isImportChanged = ResourceWatcher.this.isChanged(Resource.create(importedUri, ResourceType.CSS), groupName);
                LOG.debug("\tisImportChanged: {}", (Object)isImportChanged);
                if (isImportChanged) {
                    changeDetected.set(true);
                }
            }

            @Override
            protected String doTransform(String cssContent, List<Resource> foundImports) throws IOException {
                return "";
            }

            public String toString() {
                return CssImportPreProcessor.class.getSimpleName();
            }
        };
        ExceptionHandlingProcessorDecorator processor = new ExceptionHandlingProcessorDecorator(cssImportProcessor){

            protected boolean isIgnoreFailingProcessor() {
                return true;
            }
        };
        this.injector.inject(processor);
        return processor;
    }

    ResourceChangeDetector getResourceChangeDetector() {
        if (this.changeDetector == null) {
            this.changeDetector = new ResourceChangeDetector();
            this.injector.inject(this.changeDetector);
        }
        return this.changeDetector;
    }
}

