/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.decorator;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;

public class ExceptionHandlingProcessorDecorator
extends ProcessorDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandlingProcessorDecorator.class);
    @Inject
    private ReadOnlyContext context;

    public ExceptionHandlingProcessorDecorator(Object processor) {
        super(processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        block7: {
            String resourceContent = IOUtils.toString((Reader)reader);
            StringReader innerReader = new StringReader(resourceContent);
            StringWriter innerWriter = new StringWriter();
            try {
                super.process(resource, innerReader, innerWriter);
                writer.write(innerWriter.toString());
            }
            catch (Exception e) {
                String processorName = this.toString();
                LOG.debug("Failed to process the resource: {} using processor: {}. Reason: {}", new Object[]{resource, processorName, e.getMessage()});
                LOG.debug("Original Exception", (Throwable)e);
                if (this.isIgnoreFailingProcessor()) {
                    writer.write(resourceContent);
                    break block7;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw WroRuntimeException.wrap(e, "The processor: " + processorName + " failed");
            }
            finally {
                reader.close();
                writer.close();
            }
        }
    }

    protected boolean isIgnoreFailingProcessor() {
        return this.context.getConfig().isIgnoreFailingProcessor();
    }
}

