/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.http.support.RedirectedStreamServletResponseWrapper;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.util.WroUtil;

public class DispatcherStreamLocator {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherStreamLocator.class);
    @Inject
    private Injector injector;
    public static final String ATTRIBUTE_INCLUDED_BY_DISPATCHER = DispatcherStreamLocator.class.getName() + ".included_with_dispatcher";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(HttpServletRequest request, HttpServletResponse response, String location) throws IOException {
        Validate.notNull((Object)request);
        Validate.notNull((Object)response);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean warnOnEmptyStream = false;
        try {
            RequestDispatcher dispatcher = request.getRequestDispatcher(location);
            if (dispatcher != null) {
                ServletRequest servletRequest = this.getWrappedServletRequest(request, location);
                RedirectedStreamServletResponseWrapper servletResponse = new RedirectedStreamServletResponseWrapper(os, response);
                LOG.debug("dispatching request to location: {}", (Object)location);
                dispatcher.include(servletRequest, (ServletResponse)servletResponse);
                warnOnEmptyStream = true;
                servletResponse.getWriter().flush();
                os.close();
            }
        }
        catch (Exception e) {
            LOG.debug("[FAIL] Error while dispatching the request for location {}", (Object)location);
            return this.locateExternal(request, location);
        }
        try {
            if (os.size() == 0) {
                InputStream inputStream = this.locateExternal(request, location);
                return inputStream;
            }
        }
        finally {
            if (warnOnEmptyStream && os.size() == 0) {
                LOG.debug("Wrong or empty resource with location: {}", (Object)location);
            }
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    private InputStream locateExternal(HttpServletRequest request, String location) throws IOException {
        String servletContextPath = request.getRequestURL().toString().replace(request.getServletPath(), "");
        String absolutePath = servletContextPath + location;
        return this.createExternalResourceLocator().locate(absolutePath);
    }

    UriLocator createExternalResourceLocator() {
        UrlUriLocator locator = new UrlUriLocator(){

            public boolean isEnableWildcards() {
                return false;
            }
        };
        this.injector.inject(locator);
        return locator;
    }

    private ServletRequest getWrappedServletRequest(HttpServletRequest request, final String location) {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public String getRequestURI() {
                return this.getContextPath() + location;
            }

            public String getPathInfo() {
                return WroUtil.getPathInfoFromLocation((HttpServletRequest)this, location);
            }

            public String getServletPath() {
                return WroUtil.getServletPathFromLocation((HttpServletRequest)this, location);
            }
        };
        wrappedRequest.setAttribute(ATTRIBUTE_INCLUDED_BY_DISPATCHER, (Object)Boolean.TRUE);
        return wrappedRequest;
    }

    public static boolean isIncludedRequest(HttpServletRequest request) {
        Validate.notNull((Object)request);
        return request.getAttribute(ATTRIBUTE_INCLUDED_BY_DISPATCHER) != null;
    }
}

