/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.decorator.DefaultProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.util.StopWatch;

public class GroupsProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GroupsProcessor.class);
    @Inject
    private LifecycleCallbackRegistry callbackRegistry;
    @Inject
    private ProcessorsFactory processorsFactory;
    @Inject
    private WroModelFactory modelFactory;
    @Inject
    private ReadOnlyContext context;
    @Inject
    private Injector injector;
    @Inject
    private transient PreProcessorExecutor preProcessorExecutor;

    public String process(CacheKey cacheKey) {
        Validate.notNull((Object)cacheKey);
        try {
            LOG.debug("Starting processing group [{}] of type [{}] with minimized flag: " + cacheKey.isMinimize(), (Object)cacheKey.getGroupName(), (Object)cacheKey.getType());
            WroModel model = (WroModel)this.modelFactory.create();
            Group group = model.getGroupByName(cacheKey.getGroupName());
            Group filteredGroup = group.collectResourcesOfType(cacheKey.getType());
            if (filteredGroup.getResources().isEmpty()) {
                LOG.debug("No resources found in group: {} and resource type: {}", (Object)group.getName(), (Object)cacheKey.getType());
                if (!this.context.getConfig().isIgnoreEmptyGroup()) {
                    throw new WroRuntimeException("No resources found in group: " + group.getName());
                }
            }
            String result = this.preProcessorExecutor.processAndMerge(filteredGroup.getResources(), cacheKey.isMinimize());
            String string = this.applyPostProcessors(cacheKey, result);
            return string;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Exception while merging resources: " + e.getMessage(), e).logError();
        }
        finally {
            this.callbackRegistry.onProcessingComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String applyPostProcessors(CacheKey cacheKey, String content) throws IOException {
        Collection<ResourcePostProcessor> processors = this.processorsFactory.getPostProcessors();
        if (processors.isEmpty()) {
            return content;
        }
        Resource resource = Resource.create(cacheKey.getGroupName(), cacheKey.getType());
        StringReader reader = new StringReader(content.toString());
        Object writer = null;
        StopWatch stopWatch = new StopWatch();
        for (ResourcePostProcessor processor : processors) {
            ProcessorDecorator decoratedProcessor = this.decorateProcessor(processor, cacheKey.isMinimize());
            stopWatch.start("Using " + ((Object)decoratedProcessor).toString());
            writer = new StringWriter();
            try {
                this.callbackRegistry.onBeforePostProcess();
                decoratedProcessor.process(resource, reader, (Writer)writer);
            }
            finally {
                stopWatch.stop();
                this.callbackRegistry.onAfterPostProcess();
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Writer)writer);
            }
            reader = new StringReader(writer.toString());
        }
        LOG.debug(stopWatch.prettyPrint());
        return writer.toString();
    }

    private ProcessorDecorator decorateProcessor(ResourcePostProcessor processor, boolean minimize) {
        DefaultProcessorDecorator decorated = new DefaultProcessorDecorator((Object)processor, minimize);
        this.injector.inject(decorated);
        return decorated;
    }
}

