/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.cache.factory.CacheKeyFactory;
import ro.isdc.wro.cache.factory.DefaultCacheKeyFactory;
import ro.isdc.wro.cache.impl.LruMemoryCacheStrategy;
import ro.isdc.wro.config.metadata.DefaultMetaDataFactory;
import ro.isdc.wro.config.metadata.MetaDataFactory;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.group.DefaultGroupExtractor;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.resource.locator.factory.DefaultUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.factory.DefaultProcesorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.support.DefaultResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.hash.SHA1HashStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;
import ro.isdc.wro.model.resource.support.naming.NoOpNamingStrategy;
import ro.isdc.wro.model.transformer.WildcardExpanderModelTransformer;
import ro.isdc.wro.util.DestroyableLazyInitializer;
import ro.isdc.wro.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseWroManagerFactory
implements WroManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BaseWroManagerFactory.class);
    private GroupExtractor groupExtractor;
    private WroModelFactory modelFactory;
    private CacheStrategy<CacheKey, CacheValue> cacheStrategy;
    private HashStrategy hashStrategy;
    private List<Transformer<WroModel>> modelTransformers;
    private UriLocatorFactory uriLocatorFactory;
    private ProcessorsFactory processorsFactory;
    private NamingStrategy namingStrategy;
    private ResourceAuthorizationManager authorizationManager;
    private CacheKeyFactory cacheKeyFactory;
    private MetaDataFactory metaDataFactory;
    private final DestroyableLazyInitializer<WroManager> managerInitializer = new DestroyableLazyInitializer<WroManager>(){

        @Override
        protected WroManager initialize() {
            WroManager manager = new WroManager();
            if (BaseWroManagerFactory.this.modelFactory == null) {
                BaseWroManagerFactory.this.modelFactory = BaseWroManagerFactory.this.newModelFactory();
            }
            if (BaseWroManagerFactory.this.groupExtractor == null) {
                BaseWroManagerFactory.this.groupExtractor = BaseWroManagerFactory.this.newGroupExtractor();
            }
            if (BaseWroManagerFactory.this.cacheStrategy == null) {
                BaseWroManagerFactory.this.cacheStrategy = BaseWroManagerFactory.this.newCacheStrategy();
            }
            if (BaseWroManagerFactory.this.hashStrategy == null) {
                BaseWroManagerFactory.this.hashStrategy = BaseWroManagerFactory.this.newHashStrategy();
            }
            if (BaseWroManagerFactory.this.modelTransformers == null) {
                BaseWroManagerFactory.this.modelTransformers = BaseWroManagerFactory.this.newModelTransformers();
            }
            if (BaseWroManagerFactory.this.processorsFactory == null) {
                BaseWroManagerFactory.this.processorsFactory = BaseWroManagerFactory.this.newProcessorsFactory();
            }
            if (BaseWroManagerFactory.this.uriLocatorFactory == null) {
                BaseWroManagerFactory.this.uriLocatorFactory = BaseWroManagerFactory.this.newUriLocatorFactory();
            }
            if (BaseWroManagerFactory.this.namingStrategy == null) {
                BaseWroManagerFactory.this.namingStrategy = BaseWroManagerFactory.this.newNamingStrategy();
            }
            if (BaseWroManagerFactory.this.authorizationManager == null) {
                BaseWroManagerFactory.this.authorizationManager = BaseWroManagerFactory.this.newAuthorizationManager();
            }
            if (BaseWroManagerFactory.this.cacheKeyFactory == null) {
                BaseWroManagerFactory.this.cacheKeyFactory = BaseWroManagerFactory.this.newCacheKeyFactory();
            }
            if (BaseWroManagerFactory.this.metaDataFactory == null) {
                BaseWroManagerFactory.this.metaDataFactory = BaseWroManagerFactory.this.newMetaDataFactory();
            }
            manager.setGroupExtractor(BaseWroManagerFactory.this.groupExtractor);
            manager.setCacheStrategy(BaseWroManagerFactory.this.cacheStrategy);
            manager.setHashStrategy(BaseWroManagerFactory.this.hashStrategy);
            manager.setUriLocatorFactory(BaseWroManagerFactory.this.uriLocatorFactory);
            manager.setProcessorsFactory(BaseWroManagerFactory.this.processorsFactory);
            manager.setNamingStrategy(BaseWroManagerFactory.this.namingStrategy);
            manager.setModelFactory(BaseWroManagerFactory.this.modelFactory);
            manager.setModelTransformers(BaseWroManagerFactory.this.modelTransformers);
            manager.setResourceAuthorizationManager(BaseWroManagerFactory.this.authorizationManager);
            manager.setCacheKeyFactory(BaseWroManagerFactory.this.cacheKeyFactory);
            manager.setMetaDataFactory(BaseWroManagerFactory.this.metaDataFactory);
            BaseWroManagerFactory.this.onAfterInitializeManager(manager);
            return manager;
        }
    };

    @Override
    public final WroManager create() {
        return (WroManager)this.managerInitializer.get();
    }

    protected ResourceAuthorizationManager newAuthorizationManager() {
        return new DefaultResourceAuthorizationManager();
    }

    protected void onAfterInitializeManager(WroManager manager) {
    }

    public BaseWroManagerFactory setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    protected List<Transformer<WroModel>> newModelTransformers() {
        this.addModelTransformer(new WildcardExpanderModelTransformer());
        return this.modelTransformers;
    }

    protected ProcessorsFactory newProcessorsFactory() {
        return new DefaultProcesorsFactory();
    }

    protected UriLocatorFactory newUriLocatorFactory() {
        return new DefaultUriLocatorFactory();
    }

    protected HashStrategy newHashStrategy() {
        return new SHA1HashStrategy();
    }

    protected NamingStrategy newNamingStrategy() {
        return new NoOpNamingStrategy();
    }

    @Override
    public void onCachePeriodChanged(long period) {
        try {
            ((WroManager)this.managerInitializer.get()).onCachePeriodChanged(period);
        }
        catch (WroRuntimeException e) {
            LOG.warn("[FAIL] Unable to reload cache, probably because invoked outside of context");
        }
    }

    @Override
    public void onModelPeriodChanged(long period) {
        try {
            ((WroManager)this.managerInitializer.get()).onModelPeriodChanged(period);
        }
        catch (WroRuntimeException e) {
            LOG.warn("[FAIL] Unable to reload model, probably because invoked outside of context");
        }
    }

    protected CacheStrategy<CacheKey, CacheValue> newCacheStrategy() {
        return new LruMemoryCacheStrategy<CacheKey, CacheValue>();
    }

    protected GroupExtractor newGroupExtractor() {
        return new DefaultGroupExtractor();
    }

    protected CacheKeyFactory newCacheKeyFactory() {
        return new DefaultCacheKeyFactory();
    }

    protected WroModelFactory newModelFactory() {
        try {
            LOG.debug("Trying to use SmartWroModelFactory as default model factory");
            Class<WroModelFactory> smartFactoryClass = Class.forName("ro.isdc.wro.extensions.model.factory.SmartWroModelFactory").asSubclass(WroModelFactory.class);
            return smartFactoryClass.newInstance();
        }
        catch (Exception e) {
            LOG.debug("SmartWroModelFactory is not available. Using default model factory.");
            LOG.debug("Reason: {}", (Object)e.getMessage());
            return new XmlModelFactory();
        }
    }

    protected MetaDataFactory newMetaDataFactory() {
        return new DefaultMetaDataFactory();
    }

    public BaseWroManagerFactory setGroupExtractor(GroupExtractor groupExtractor) {
        this.groupExtractor = groupExtractor;
        return this;
    }

    public BaseWroManagerFactory setModelFactory(WroModelFactory modelFactory) {
        this.modelFactory = modelFactory;
        return this;
    }

    @Deprecated
    public BaseWroManagerFactory setHashBuilder(HashStrategy hashBuilder) {
        this.hashStrategy = hashBuilder;
        return this;
    }

    public BaseWroManagerFactory setHashStrategy(HashStrategy hashStrategy) {
        this.hashStrategy = hashStrategy;
        return this;
    }

    public void setCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
        this.cacheKeyFactory = cacheKeyFactory;
    }

    public BaseWroManagerFactory setModelTransformers(List<Transformer<WroModel>> modelTransformers) {
        this.modelTransformers = modelTransformers;
        return this;
    }

    public BaseWroManagerFactory addModelTransformer(Transformer<WroModel> modelTransformer) {
        if (this.modelTransformers == null) {
            this.modelTransformers = new ArrayList<Transformer<WroModel>>();
        }
        this.modelTransformers.add(modelTransformer);
        return this;
    }

    public BaseWroManagerFactory setCacheStrategy(CacheStrategy<CacheKey, CacheValue> cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
        return this;
    }

    public BaseWroManagerFactory setUriLocatorFactory(UriLocatorFactory uriLocatorFactory) {
        this.uriLocatorFactory = uriLocatorFactory;
        return this;
    }

    public void setProcessorsFactory(ProcessorsFactory processorsFactory) {
        this.processorsFactory = processorsFactory;
    }

    public BaseWroManagerFactory setResourceAuthorizationManager(ResourceAuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
        return this;
    }

    public void setMetaDataFactory(MetaDataFactory metaDataFactory) {
        this.metaDataFactory = metaDataFactory;
    }

    @Override
    public void destroy() {
        this.managerInitializer.destroy();
    }
}

