/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.cache.factory.CacheKeyFactory;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.config.metadata.MetaDataFactory;
import ro.isdc.wro.config.support.ContextPropagatingCallable;
import ro.isdc.wro.config.support.WroConfigurationChangeListener;
import ro.isdc.wro.manager.ResourceBundleProcessor;
import ro.isdc.wro.manager.callback.LifecycleCallback;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.manager.runnable.ReloadCacheRunnable;
import ro.isdc.wro.manager.runnable.ReloadModelRunnable;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;
import ro.isdc.wro.util.LazyInitializer;
import ro.isdc.wro.util.SchedulerHelper;
import ro.isdc.wro.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroManager
implements WroConfigurationChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(WroManager.class);
    private WroModelFactory modelFactory;
    private GroupExtractor groupExtractor;
    @Inject
    private CacheStrategy<CacheKey, CacheValue> cacheStrategy;
    private ProcessorsFactory processorsFactory;
    private UriLocatorFactory locatorFactory;
    @Inject
    private NamingStrategy namingStrategy;
    private LifecycleCallbackRegistry callbackRegistry;
    @Inject
    private GroupsProcessor groupsProcessor;
    @Inject
    private ReadOnlyContext context;
    private HashStrategy hashStrategy;
    private List<Transformer<WroModel>> modelTransformers = Collections.emptyList();
    private final SchedulerHelper modelSchedulerHelper;
    private final SchedulerHelper cacheSchedulerHelper = SchedulerHelper.create(new LazyInitializer<Runnable>(){

        @Override
        protected Runnable initialize() {
            return ContextPropagatingCallable.decorate(new ReloadCacheRunnable(WroManager.this.getCacheStrategy()));
        }
    }, ReloadCacheRunnable.class.getSimpleName());
    @Inject
    private ResourceBundleProcessor resourceBundleProcessor;
    private ResourceAuthorizationManager authorizationManager;
    private CacheKeyFactory cacheKeyFactory;
    private MetaDataFactory metaDataFactory;

    public WroManager() {
        this.modelSchedulerHelper = SchedulerHelper.create(new LazyInitializer<Runnable>(){

            @Override
            protected Runnable initialize() {
                return ContextPropagatingCallable.decorate(new ReloadModelRunnable(WroManager.this.getModelFactory()));
            }
        }, ReloadModelRunnable.class.getSimpleName());
    }

    public final void process() throws IOException {
        this.validate();
        WroConfiguration config = this.context.getConfig();
        this.cacheSchedulerHelper.scheduleWithPeriod(config.getCacheUpdatePeriod());
        this.modelSchedulerHelper.scheduleWithPeriod(config.getModelUpdatePeriod());
        this.resourceBundleProcessor.serveProcessedBundle();
    }

    public final String encodeVersionIntoGroupPath(String groupName, ResourceType resourceType, boolean minimize) {
        CacheKey key = new CacheKey(groupName, resourceType, minimize);
        CacheValue cacheValue = this.cacheStrategy.get(key);
        String groupUrl = this.groupExtractor.encodeGroupUrl(groupName, resourceType, minimize);
        return this.formatVersionedResource(cacheValue.getHash(), groupUrl);
    }

    protected String formatVersionedResource(String hash, String resourcePath) {
        return String.format("%s/%s", hash, resourcePath);
    }

    @Override
    public final void onCachePeriodChanged(long period) {
        LOG.info("onCachePeriodChanged with value {} has been triggered!", (Object)period);
        this.cacheSchedulerHelper.scheduleWithPeriod(period);
        this.cacheStrategy.clear();
    }

    @Override
    public final void onModelPeriodChanged(long period) {
        LOG.info("onModelPeriodChanged with value {} has been triggered!", (Object)period);
        this.getModelFactory().destroy();
        this.modelSchedulerHelper.scheduleWithPeriod(period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        try {
            this.cacheSchedulerHelper.destroy();
            this.modelSchedulerHelper.destroy();
            this.cacheStrategy.destroy();
            this.modelFactory.destroy();
        }
        catch (Exception e) {
            LOG.error("Exception occured during manager destroy!!!");
        }
        finally {
            LOG.debug("WroManager destroyed");
        }
    }

    private void validate() {
        Validate.notNull(this.cacheStrategy, (String)"cacheStrategy was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.groupsProcessor, (String)"groupsProcessor was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.locatorFactory, (String)"uriLocatorFactory was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.processorsFactory, (String)"processorsFactory was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.groupExtractor, (String)"GroupExtractor was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.modelFactory, (String)"ModelFactory was not set!", (Object[])new Object[0]);
        Validate.notNull(this.cacheStrategy, (String)"cacheStrategy was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.hashStrategy, (String)"HashStrategy was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.authorizationManager, (String)"authorizationManager was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.metaDataFactory, (String)"metaDataFactory was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.cacheKeyFactory, (String)"CacheKeyFactory was not set!", (Object[])new Object[0]);
    }

    public final WroManager setGroupExtractor(GroupExtractor groupExtractor) {
        Validate.notNull((Object)groupExtractor);
        this.groupExtractor = groupExtractor;
        return this;
    }

    public final WroManager setModelFactory(WroModelFactory modelFactory) {
        Validate.notNull((Object)modelFactory);
        this.modelFactory = modelFactory;
        return this;
    }

    public final WroManager setCacheStrategy(CacheStrategy<CacheKey, CacheValue> cacheStrategy) {
        Validate.notNull(cacheStrategy);
        this.cacheStrategy = cacheStrategy;
        return this;
    }

    public final WroManager setHashStrategy(HashStrategy hashStrategy) {
        Validate.notNull((Object)hashStrategy);
        this.hashStrategy = hashStrategy;
        return this;
    }

    public final HashStrategy getHashStrategy() {
        return this.hashStrategy;
    }

    public final WroModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public final ProcessorsFactory getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final WroManager setProcessorsFactory(ProcessorsFactory processorsFactory) {
        this.processorsFactory = processorsFactory;
        return this;
    }

    public final void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public final WroManager setUriLocatorFactory(UriLocatorFactory uriLocatorFactory) {
        this.locatorFactory = uriLocatorFactory;
        return this;
    }

    public final CacheStrategy<CacheKey, CacheValue> getCacheStrategy() {
        return this.cacheStrategy;
    }

    public final UriLocatorFactory getUriLocatorFactory() {
        return this.locatorFactory;
    }

    public final NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public final GroupExtractor getGroupExtractor() {
        return this.groupExtractor;
    }

    public final GroupsProcessor getGroupsProcessor() {
        return this.groupsProcessor;
    }

    public CacheKeyFactory getCacheKeyFactory() {
        return this.cacheKeyFactory;
    }

    public void setCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
        this.cacheKeyFactory = cacheKeyFactory;
    }

    public MetaDataFactory getMetaDataFactory() {
        return this.metaDataFactory;
    }

    public void setMetaDataFactory(MetaDataFactory metaDataFactory) {
        this.metaDataFactory = metaDataFactory;
    }

    public final void registerCallback(LifecycleCallback callback) {
        Validate.notNull((Object)callback);
        this.getCallbackRegistry().registerCallback(callback);
    }

    public final List<Transformer<WroModel>> getModelTransformers() {
        return this.modelTransformers;
    }

    public final void setModelTransformers(List<Transformer<WroModel>> modelTransformers) {
        this.modelTransformers = modelTransformers;
    }

    public LifecycleCallbackRegistry getCallbackRegistry() {
        if (this.callbackRegistry == null) {
            this.callbackRegistry = new LifecycleCallbackRegistry();
        }
        return this.callbackRegistry;
    }

    public ResourceAuthorizationManager getResourceAuthorizationManager() {
        return this.authorizationManager;
    }

    public void setResourceAuthorizationManager(ResourceAuthorizationManager authorizationManager) {
        Validate.notNull((Object)authorizationManager);
        this.authorizationManager = authorizationManager;
    }
}

