/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.cache;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;

public final class CacheValue
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CacheValue.class);
    private String rawContent;
    private byte[] gzippedContent;
    private String hash;

    private CacheValue(String rawContent, String hash) {
        this.rawContent = rawContent;
        this.hash = hash;
        if (Context.get().getConfig().isCacheGzippedContent()) {
            this.gzippedContent = this.computeGzippedContent(rawContent);
        }
    }

    private byte[] computeGzippedContent(String content) {
        LOG.debug("Gzipping the content....");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream os = new GZIPOutputStream(new BufferedOutputStream(baos));
            IOUtils.copy((InputStream)new ByteArrayInputStream(content.getBytes(Context.get().getConfig().getEncoding())), (OutputStream)os);
            ((OutputStream)os).close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw WroRuntimeException.wrap(e, "Problem while computing gzipped content").logError();
        }
    }

    public static final CacheValue valueOf(String rawContent, String hash) {
        return new CacheValue(rawContent, hash);
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public byte[] getGzippedContent() {
        if (this.gzippedContent == null) {
            return this.computeGzippedContent(this.rawContent);
        }
        return this.gzippedContent;
    }

    byte[] getGzippedContentInternal() {
        return this.gzippedContent;
    }

    public String toString() {
        return "hash: " + this.hash;
    }
}

