/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.mailsender.simple;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.codehaus.plexus.mailsender.simple.ErrorInQuitException;
import org.codehaus.plexus.mailsender.simple.SmtpResponseReader;

public class SimpleMailMessage {
    public static final int DEFAULT_PORT = 25;
    private String host;
    private int port = 25;
    private String from;
    private Vector to;
    private Vector cc;
    private Hashtable headers;
    private MailPrintStream out;
    private SmtpResponseReader in;
    private Socket socket;
    static /* synthetic */ Class class$org$codehaus$plexus$mailsender$MailSender;

    public SimpleMailMessage() throws IOException {
        this("localhost", 25);
    }

    public SimpleMailMessage(String host) throws IOException {
        this(host, 25);
    }

    public SimpleMailMessage(String host, int port) throws IOException {
        this.port = port;
        this.host = host;
        this.to = new Vector();
        this.cc = new Vector();
        this.headers = new Hashtable();
        this.setHeader("X-Mailer", (class$org$codehaus$plexus$mailsender$MailSender == null ? (class$org$codehaus$plexus$mailsender$MailSender = SimpleMailMessage.class$("org.codehaus.plexus.mailsender.MailSender")) : class$org$codehaus$plexus$mailsender$MailSender).getName() + " (plexus.codehaus.org)");
        this.connect();
        this.sendHelo();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void from(String from) throws IOException {
        this.sendFrom(from);
        this.from = from;
    }

    public void to(String to) throws IOException {
        this.sendRcpt(to);
        this.to.addElement(to);
    }

    public void cc(String cc) throws IOException {
        this.sendRcpt(cc);
        this.cc.addElement(cc);
    }

    public void bcc(String bcc) throws IOException {
        this.sendRcpt(bcc);
    }

    public void setSubject(String subj) {
        this.headers.put("Subject", subj);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public PrintStream getPrintStream() throws IOException {
        this.setFromHeader();
        this.setToHeader();
        this.setCcHeader();
        this.sendData();
        this.flushHeaders();
        return this.out;
    }

    private void setFromHeader() {
        this.setHeader("From", this.from);
    }

    private void setToHeader() {
        if (this.to.size() > 0) {
            this.setHeader("To", this.vectorToList(this.to));
        }
    }

    private void setCcHeader() {
        if (this.cc.size() > 0) {
            this.setHeader("Cc", this.vectorToList(this.cc));
        }
    }

    private String vectorToList(Vector v) {
        StringBuffer buf = new StringBuffer();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            buf.append(e.nextElement());
            if (!e.hasMoreElements()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private void flushHeaders() throws IOException {
        Enumeration e = this.headers.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = (String)this.headers.get(name);
            this.out.println(name + ": " + value);
        }
        this.out.println();
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndClose() throws IOException {
        try {
            this.sendDot();
            this.sendQuit();
        }
        finally {
            this.disconnect();
        }
    }

    private static String sanitizeAddress(String s) {
        int paramDepth = 0;
        int start = 0;
        int end = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '(') {
                ++paramDepth;
                if (start != 0) continue;
                end = i;
                continue;
            }
            if (c == ')') {
                --paramDepth;
                if (end != 0) continue;
                start = i + 1;
                continue;
            }
            if (paramDepth == 0 && c == '<') {
                start = i + 1;
                continue;
            }
            if (paramDepth != 0 || c != '>') continue;
            end = i;
        }
        if (end == 0) {
            end = len;
        }
        return s.substring(start, end);
    }

    private void connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.out = new MailPrintStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.in = new SmtpResponseReader(this.socket.getInputStream());
        this.getReady();
    }

    private void getReady() throws IOException {
        String response = this.in.getResponse();
        int[] ok = new int[]{220};
        if (!this.isResponseOK(response, ok)) {
            throw new IOException("Didn't get introduction from server: " + response);
        }
    }

    private void sendHelo() throws IOException {
        String local = InetAddress.getLocalHost().getHostName();
        int[] ok = new int[]{250};
        this.send("HELO " + local, ok);
    }

    private void sendFrom(String from) throws IOException {
        int[] ok = new int[]{250};
        this.send("MAIL FROM: <" + SimpleMailMessage.sanitizeAddress(from) + ">", ok);
    }

    private void sendRcpt(String rcpt) throws IOException {
        int[] ok = new int[]{250, 251};
        this.send("RCPT TO: <" + SimpleMailMessage.sanitizeAddress(rcpt) + ">", ok);
    }

    private void sendData() throws IOException {
        int[] ok = new int[]{354};
        this.send("DATA", ok);
    }

    private void sendDot() throws IOException {
        int[] ok = new int[]{250};
        this.send("\r\n.", ok);
    }

    private void sendQuit() throws IOException {
        int[] ok = new int[]{221};
        try {
            this.send("QUIT", ok);
        }
        catch (IOException e) {
            throw new ErrorInQuitException(e);
        }
    }

    private void send(String msg, int[] ok) throws IOException {
        this.out.rawPrint(msg + "\r\n");
        String response = this.in.getResponse();
        if (!this.isResponseOK(response, ok)) {
            throw new IOException("Unexpected reply to command: " + msg + ": " + response);
        }
    }

    private boolean isResponseOK(String response, int[] ok) {
        for (int i = 0; i < ok.length; ++i) {
            if (!response.startsWith("" + ok[i])) continue;
            return true;
        }
        return false;
    }

    private void disconnect() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MailPrintStream
    extends PrintStream {
        int lastChar;

        public MailPrintStream(OutputStream out) {
            super(out, true);
        }

        public void write(int b) {
            if (b == 10 && this.lastChar != 13) {
                this.rawWrite(13);
                this.rawWrite(b);
            } else if (b == 46 && this.lastChar == 10) {
                this.rawWrite(46);
                this.rawWrite(b);
            } else {
                this.rawWrite(b);
            }
            this.lastChar = b;
        }

        public void write(byte[] buf, int off, int len) {
            for (int i = 0; i < len; ++i) {
                this.write(buf[off + i]);
            }
        }

        void rawWrite(int b) {
            super.write(b);
        }

        void rawPrint(String s) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                this.rawWrite(s.charAt(i));
            }
        }
    }
}

