/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;
import pl.project13.maven.git.log.LoggerBridge;

public class PropertiesFilterer {
    private LoggerBridge log;

    public PropertiesFilterer(LoggerBridge log) {
        this.log = log;
    }

    public void filterNot(Properties properties, @Nullable List<String> exclusions, String prefixDot) {
        if (exclusions == null || exclusions.isEmpty()) {
            return;
        }
        List excludePredicates = Lists.transform(exclusions, (Function)new Function<String, Predicate<CharSequence>>(){

            public Predicate<CharSequence> apply(String exclude) {
                return Predicates.containsPattern((String)exclude);
            }
        });
        Predicate shouldExclude = Predicates.alwaysFalse();
        for (Predicate predicate : excludePredicates) {
            shouldExclude = Predicates.or((Predicate)shouldExclude, (Predicate)predicate);
        }
        for (String key : properties.stringPropertyNames()) {
            if (!this.isOurProperty(key, prefixDot) || !shouldExclude.apply((Object)key)) continue;
            this.log.debug("shouldExclude.apply({}) = {}", (Object)key, (Object)shouldExclude.apply((Object)key));
            properties.remove(key);
        }
    }

    public void filter(Properties properties, @Nullable List<String> inclusions, String prefixDot) {
        if (inclusions == null || inclusions.isEmpty()) {
            return;
        }
        List includePredicates = Lists.transform(inclusions, (Function)new Function<String, Predicate<CharSequence>>(){

            public Predicate<CharSequence> apply(String exclude) {
                return Predicates.containsPattern((String)exclude);
            }
        });
        Predicate shouldInclude = Predicates.alwaysFalse();
        for (Predicate predicate : includePredicates) {
            shouldInclude = Predicates.or((Predicate)shouldInclude, (Predicate)predicate);
        }
        for (String key : properties.stringPropertyNames()) {
            if (!this.isOurProperty(key, prefixDot) || shouldInclude.apply((Object)key)) continue;
            this.log.debug("!shouldInclude.apply({}) = {}", (Object)key, (Object)shouldInclude.apply((Object)key));
            properties.remove(key);
        }
    }

    private boolean isOurProperty(String key, String prefixDot) {
        return key.startsWith(prefixDot);
    }
}

