/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LoggerBridge;

public class GitHubBuildServerData
extends BuildServerDataProvider {
    private static final String BRANCH_REF_PREFIX = "refs/heads/";
    private static final String PULL_REQUEST_REF_PREFIX = "refs/pull/";

    GitHubBuildServerData(LoggerBridge log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("GITHUB_ACTIONS");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
    }

    @Override
    public String getBuildBranch() {
        String gitHubRef = (String)this.env.get("GITHUB_REF");
        if (gitHubRef != null && !gitHubRef.isEmpty()) {
            if (gitHubRef.startsWith(BRANCH_REF_PREFIX)) {
                String branchName = gitHubRef.substring(BRANCH_REF_PREFIX.length());
                this.log.info("Using environment variable based branch name. GITHUB_REF = {} (branch = {})", (Object)gitHubRef, (Object)branchName);
                return branchName;
            }
            if (gitHubRef.startsWith(PULL_REQUEST_REF_PREFIX)) {
                String branchName = (String)this.env.get("GITHUB_HEAD_REF");
                this.log.info("Using environment variable based branch name. GITHUB_HEAD_REF = {}", (Object)branchName);
                return branchName;
            }
        }
        return "";
    }
}

