/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.zkoss.util.resource.LabelLocator;

public class ServletLabelLocator
implements LabelLocator {
    private final ServletContext _ctx;

    public ServletLabelLocator(ServletContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("null");
        }
        this._ctx = ctx;
    }

    public URL locate(Locale locale) throws IOException {
        return this._ctx.getResource("/WEB-INF/" + ServletLabelLocator.getI3LabelName(locale));
    }

    private static final String getI3LabelName(Locale locale) {
        return locale.equals(Locale.ENGLISH) ? "i3-label.properties" : "i3-label_" + locale + ".properties";
    }

    public int hashCode() {
        return this._ctx.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ServletLabelLocator && ((ServletLabelLocator)o)._ctx.equals(this._ctx);
    }
}

