/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.impl;

import java.io.IOException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.ServletException;
import org.zkoss.web.servlet.dsp.impl.InterpretContext;
import org.zkoss.web.servlet.dsp.impl.Node;

class ELNode
extends Node {
    private static final Log log = Log.lookup((Class)ELNode.class);
    private final String _expr;

    ELNode(String expr) {
        this._expr = expr;
    }

    void interpret(InterpretContext ic) throws javax.servlet.ServletException, IOException {
        try {
            String result = (String)ic.dc.getExpressionEvaluator().evaluate(this._expr, String.class, (VariableResolver)ic.resolver, ic.mapper);
            if (result != null) {
                ic.dc.getOut().write(result);
            }
        }
        catch (ELException ex) {
            log.realCause((Throwable)ex);
            throw new ServletException("Unable to evaluate an EL expression: " + this._expr, (Throwable)ex);
        }
    }

    void addChild(Node node) {
        throw new IllegalStateException("No child allowed");
    }

    public String toString() {
        return "EL[" + this._expr + ']';
    }
}

