/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.lang.SystemException;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Checksums;
import org.zkoss.util.Locales;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.portlet.RenderHttpServletRequest;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.util.resource.ExtendedWebContext;
import org.zkoss.web.util.resource.ServletContextLocator;

public class Servlets {
    private static final Log log = Log.lookup((Class)Servlets.class);
    private static Boolean _elSupported = null;
    public static final int OVERWRITE_URI = 0;
    public static final int IGNORE_PARAM = 1;
    public static final int APPEND_PARAM = 2;
    public static final int PASS_THRU_ATTR = 3;
    private static List _ctxroots;

    protected Servlets() {
    }

    public static final boolean isUniversalURL(String uri) {
        if (uri == null || uri.length() == 0) {
            return false;
        }
        char cc = uri.charAt(0);
        return cc >= 'a' && cc <= 'z' && (uri.indexOf("://") > 0 || uri.startsWith("mailto:") || uri.startsWith("javascript:") || uri.startsWith("about:"));
    }

    public static final String locate(ServletContext ctx, ServletRequest request, String pgpath, Locator locator) throws ServletException {
        Locale locale;
        URIIndex index;
        String uri;
        String qstr;
        if (Servlets.isUniversalURL(pgpath)) {
            return pgpath;
        }
        int jquest = pgpath.indexOf(63);
        int f = pgpath.indexOf(42);
        if (f < 0 || jquest >= 0 && f > jquest) {
            return pgpath;
        }
        if (jquest >= 0) {
            qstr = pgpath.substring(jquest);
            pgpath = pgpath.substring(0, jquest);
        } else {
            qstr = null;
        }
        int l = pgpath.lastIndexOf(42);
        if (l > f) {
            String bc = Servlets.isExplorer(request) ? "ie" : (Servlets.isSafari(request) ? "saf" : "moz");
            l += bc.length() - 1;
            pgpath = pgpath.substring(0, f) + bc + pgpath.substring(f + 1);
        }
        if (l < pgpath.length() - 1 && (pgpath.charAt(l + 1) != '.' || pgpath.indexOf(47, l + 1) >= 0)) {
            return qstr != null ? pgpath + qstr : pgpath;
        }
        pgpath = pgpath.substring(0, l) + pgpath.substring(l + 1);
        String PGPATH_CACHE = "s_pgpath_cache";
        Map<URIIndex, String> map = (Map<URIIndex, String>)ctx.getAttribute("s_pgpath_cache");
        if (map == null) {
            map = Collections.synchronizedMap(new CacheMap(53).setMaxSize(500).setLifetime(600000));
            ctx.setAttribute("s_pgpath_cache", map);
        }
        if ((uri = (String)map.get(index = new URIIndex(pgpath, locale = Locales.getCurrent()))) == null) {
            Locators.URLLocation loc = Locators.locate((String)pgpath, (Locale)locale, (Locator)(locator != null ? locator : new ServletContextLocator(ctx)));
            uri = loc != null ? loc.file : pgpath;
            map.put(index, uri);
        }
        return qstr != null ? uri + qstr : uri;
    }

    public static final String locate(PageContext ctx, String pgpath) throws ServletException {
        return Servlets.locate(ctx.getServletContext(), ctx.getRequest(), pgpath, null);
    }

    public static final boolean isRobot(ServletRequest req) {
        String agt;
        String string = agt = req instanceof HttpServletRequest ? ((HttpServletRequest)req).getHeader("user-agent") : null;
        if (agt == null) {
            return false;
        }
        return (agt = agt.toLowerCase()).indexOf("msie") < 0 && agt.indexOf("opera") < 0 && agt.indexOf("gecko/") < 0 && agt.indexOf("safari") < 0;
    }

    public static final boolean isExplorer(ServletRequest req) {
        String agt;
        String string = agt = req instanceof HttpServletRequest ? ((HttpServletRequest)req).getHeader("user-agent") : null;
        if (agt == null) {
            return false;
        }
        return (agt = agt.toLowerCase()).indexOf("msie") >= 0 && agt.indexOf("opera") < 0;
    }

    public static final boolean isExplorer7(ServletRequest req) {
        String agt;
        String string = agt = req instanceof HttpServletRequest ? ((HttpServletRequest)req).getHeader("user-agent") : null;
        if (agt == null) {
            return false;
        }
        return (agt = agt.toLowerCase()).indexOf("msie 7") >= 0;
    }

    public static final boolean isGecko(ServletRequest req) {
        String agt;
        String string = agt = req instanceof HttpServletRequest ? ((HttpServletRequest)req).getHeader("user-agent") : null;
        if (agt == null) {
            return false;
        }
        return (agt = agt.toLowerCase()).indexOf("gecko/") >= 0 && agt.indexOf("safari") < 0;
    }

    public static final boolean isSafari(ServletRequest req) {
        String agt;
        String string = agt = req instanceof HttpServletRequest ? ((HttpServletRequest)req).getHeader("user-agent") : null;
        if (agt == null) {
            return false;
        }
        return (agt = agt.toLowerCase()).indexOf("safari") >= 0;
    }

    public static final boolean isIncluded(ServletRequest request) {
        return request.getAttribute("javax.servlet.include.context_path") != null;
    }

    public static final boolean isForwarded(ServletRequest request) {
        return request.getAttribute("javax.servlet.forward.context_path") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void forward(ServletContext ctx, ServletRequest request, ServletResponse response, String uri, Map params, int mode) throws IOException, ServletException {
        if (log.debugable()) {
            log.debug("Forwarding " + uri);
        }
        if (Servlets.isIncluded(request)) {
            Servlets.include(ctx, request, response, uri, params, mode);
            return;
        }
        RequestDispatcher disp = Servlets.getRequestDispatcher(ctx, request, uri, params, mode);
        if (disp == null) {
            throw new ServletException("No dispatcher available to forward to " + uri);
        }
        if (mode == 3 && params != null && !params.isEmpty()) {
            Map old = Servlets.setPassThruAttr(request, params);
            try {
                disp.forward(request, response);
                return;
            }
            catch (ClassCastException ex) {
                if (request instanceof RenderHttpServletRequest) return;
                throw ex;
            }
            finally {
                Servlets.restorePassThruAttr(request, old);
            }
        } else {
            disp.forward(request, response);
        }
    }

    public static final void forward(ServletContext ctx, ServletRequest request, ServletResponse response, String uri) throws IOException, ServletException {
        Servlets.forward(ctx, request, response, uri, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void include(ServletContext ctx, ServletRequest request, ServletResponse response, String uri, Map params, int mode) throws IOException, ServletException {
        if (log.debugable()) {
            log.debug("Including " + uri + " at " + ctx);
        }
        request.setAttribute("org.mortbay.jetty.servlet.Dispatcher.shared_session", (Object)Boolean.TRUE);
        RequestDispatcher disp = Servlets.getRequestDispatcher(ctx, request, uri, params, mode);
        if (disp == null) {
            throw new ServletException("No dispatcher available to include " + uri);
        }
        if (mode == 3 && params != null && !params.isEmpty()) {
            Map old = Servlets.setPassThruAttr(request, params);
            try {
                disp.include(request, response);
            }
            finally {
                Servlets.restorePassThruAttr(request, old);
            }
        } else {
            disp.include(request, response);
        }
    }

    public static final void include(ServletContext ctx, ServletRequest request, ServletResponse response, String uri) throws IOException, ServletException {
        Servlets.include(ctx, request, response, uri, null, 0);
    }

    private static final Map setPassThruAttr(ServletRequest request, Map params) {
        Map old = (Map)request.getAttribute("arg");
        request.setAttribute("arg", (Object)params);
        return old;
    }

    private static final void restorePassThruAttr(ServletRequest request, Map old) {
        if (old != null) {
            request.setAttribute("arg", (Object)old);
        } else {
            request.removeAttribute("arg");
        }
    }

    public static final RequestDispatcher getRequestDispatcher(ServletContext ctx, ServletRequest request, String uri, Map params, int mode) throws ServletException {
        char cc;
        char c = cc = uri.length() > 0 ? uri.charAt(0) : (char)'\u0000';
        if (ctx == null || cc != '/' && cc != '~') {
            if (request == null) {
                throw new IllegalArgumentException(ctx == null ? "Servlet context and request cannot be both null" : "Request is required to use revalant URI: " + uri);
            }
            if (cc == '~') {
                throw new IllegalArgumentException("Servlet context is required to use foreign URI: " + uri);
            }
            uri = Servlets.generateURI(uri, params, mode);
            return request.getRequestDispatcher(uri);
        }
        return new ParsedURI(ctx, uri).getRequestDispatcher(params, mode);
    }

    public static final URL getResource(ServletContext ctx, String uri) throws MalformedURLException {
        return new ParsedURI(ctx, uri).getResource();
    }

    public static final InputStream getResourceAsStream(ServletContext ctx, String uri) {
        return new ParsedURI(ctx, uri).getResourceAsStream();
    }

    public static final String generateURI(String uri, Map params, int mode) {
        if (uri.startsWith("~")) {
            throw new IllegalArgumentException("~ctx not supported here: " + uri);
        }
        int j = uri.indexOf(63);
        String qstr = null;
        if (j >= 0) {
            qstr = uri.substring(j);
            uri = uri.substring(0, j);
        }
        try {
            boolean noParams;
            uri = Encodes.encodeURI(uri);
            boolean noQstr = qstr == null;
            boolean bl = noParams = mode == 3 || params == null || params.isEmpty();
            if (noQstr && noParams) {
                return uri;
            }
            if (noQstr != noParams) {
                mode = 2;
            }
            StringBuffer sb = new StringBuffer(80).append(uri);
            if (qstr != null) {
                sb.append(qstr);
            }
            switch (mode) {
                case 1: {
                    Iterator it = params.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry me = it.next();
                        String nm = (String)me.getKey();
                        if (!Encodes.containsQuery(qstr, nm)) continue;
                        it.remove();
                    }
                }
                case 0: {
                    return Encodes.setToQueryString(sb, params).toString();
                }
                case 2: {
                    return Encodes.addToQueryString(sb, params).toString();
                }
            }
            throw new IllegalArgumentException("Unknown mode: " + mode);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getContextPaths() {
        if (_ctxroots != null) {
            return _ctxroots;
        }
        try {
            Class clazz = Servlets.class;
            synchronized (clazz) {
                _ctxroots = Servlets.myGetContextPaths();
                return _ctxroots;
            }
        }
        catch (Exception ex) {
            throw SystemException.Aide.wrap((Throwable)ex);
        }
    }

    private static final List myGetContextPaths() throws Exception {
        String APP_XML = "/META-INF/application.xml";
        LinkedList<String> ctxroots = new LinkedList<String>();
        URL xmlURL = Locators.getDefault().getResource("/META-INF/application.xml");
        if (xmlURL == null) {
            throw new SystemException("File not found: /META-INF/application.xml");
        }
        if (log.debugable()) {
            log.debug("Parsing /META-INF/application.xml");
        }
        Element root = new SAXBuilder(false, false, true).build(xmlURL).getRootElement();
        Iterator it = root.getElements("module").iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            String ctxroot = (String)e.getContent("web/context-root");
            if (ctxroot == null) continue;
            ctxroots.add(ctxroot.startsWith("/") ? ctxroot : "/" + ctxroot);
        }
        log.info("Context found: " + ctxroots);
        return new ArrayList(ctxroots);
    }

    public static final String getLimitTimeOffer() {
        String lto = Long.toHexString(System.currentTimeMillis());
        return lto + Checksums.getChecksum((String)lto, (String)"");
    }

    public static final boolean isOfferExpired(String lto, int timeout) {
        int len;
        int n = len = lto != null ? lto.length() : 0;
        if (len <= 1) {
            return true;
        }
        char cksm = lto.charAt(len - 1);
        if (cksm != Checksums.getChecksum((String)(lto = lto.substring(0, len - 1)), (String)"")) {
            return true;
        }
        try {
            return Long.parseLong(lto, 16) + (long)timeout * 1000L < System.currentTimeMillis();
        }
        catch (NumberFormatException ex) {
            return true;
        }
    }

    public static final ExtendedWebContext addExtendedWebContext(ServletContext ctx, String name, ExtendedWebContext extctx) {
        if (name == null || extctx == null) {
            throw new IllegalArgumentException("null");
        }
        return Servlets.getExtWebCtxs(ctx).put(name, extctx);
    }

    public static final ExtendedWebContext removeExtendedWebContext(ServletContext ctx, String name) {
        return (ExtendedWebContext)Servlets.getExtWebCtxs(ctx).remove(name);
    }

    public static final ExtendedWebContext getExtendedWebContext(ServletContext ctx, String name) {
        return (ExtendedWebContext)Servlets.getExtWebCtxs(ctx).get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map getExtWebCtxs(ServletContext ctx) {
        Class clazz = Servlets.class;
        synchronized (clazz) {
            String attr = "javax.zkoss.web.servlets.ExtendedWebContexts";
            Map ctxs = (Map)ctx.getAttribute("javax.zkoss.web.servlets.ExtendedWebContexts");
            if (ctxs == null) {
                ctxs = Collections.synchronizedMap(new HashMap(5));
                ctx.setAttribute("javax.zkoss.web.servlets.ExtendedWebContexts", ctxs);
            }
            return ctxs;
        }
    }

    public static final boolean isELSupported() {
        if (_elSupported == null) {
            try {
                if (ExpressionEvaluator.class.getName() != null) {
                    _elSupported = Boolean.TRUE;
                }
            }
            catch (Throwable ex) {
                _elSupported = Boolean.FALSE;
            }
        }
        return _elSupported;
    }

    private static class ParsedURI {
        private ServletContext _svlctx;
        private ExtendedWebContext _extctx;
        private String _uri;

        private ParsedURI(ServletContext ctx, String uri) {
            if (uri != null && uri.startsWith("~")) {
                String ctxroot;
                int j = uri.indexOf(47, 1);
                if (j >= 0) {
                    ctxroot = "/" + uri.substring(1, j);
                    this._uri = uri.substring(j);
                } else {
                    ctxroot = "/" + uri.substring(1);
                    this._uri = "/";
                }
                this._extctx = Servlets.getExtendedWebContext(ctx, ctxroot.substring(1));
                if (this._extctx == null) {
                    this._svlctx = ctx.getContext(ctxroot);
                    if (this._svlctx == null) {
                        throw new SystemException("Context not found or not visible to " + ctx + ": " + ctxroot);
                    }
                }
            } else {
                this._svlctx = ctx;
                this._uri = uri;
            }
        }

        private RequestDispatcher getRequestDispatcher(Map params, int mode) {
            if (this._extctx == null && this._svlctx == null) {
                return null;
            }
            String uri = Servlets.generateURI(this._uri, params, mode);
            return this._svlctx != null ? this._svlctx.getRequestDispatcher(uri) : this._extctx.getRequestDispatcher(uri);
        }

        private URL getResource() throws MalformedURLException {
            return this._svlctx != null ? this._svlctx.getResource(this._uri) : (this._extctx != null ? this._extctx.getResource(this._uri) : null);
        }

        private InputStream getResourceAsStream() {
            return this._svlctx != null ? this._svlctx.getResourceAsStream(this._uri) : (this._extctx != null ? this._extctx.getResourceAsStream(this._uri) : null);
        }
    }

    private static class URIIndex {
        private final String _uri;
        private final Locale _locale;

        private URIIndex(String uri, Locale locale) {
            if (uri == null || locale == null) {
                throw new IllegalArgumentException("null");
            }
            this._uri = uri;
            this._locale = locale;
        }

        public int hashCode() {
            return this._uri.hashCode();
        }

        public boolean equals(Object o) {
            URIIndex idx = (URIIndex)o;
            return this._uri.equals(idx._uri) && this._locale.equals(idx._locale);
        }
    }
}

