/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.xhtmlrenderer.util.XRLog;

@ParametersAreNonnullByDefault
public class UriResolver {
    private String _baseUri;

    @Nullable
    @CheckReturnValue
    public String resolve(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        return this.resolveUri(uri);
    }

    @Nonnull
    @CheckReturnValue
    public String resolveUri(String uri) {
        if (this._baseUri == null) {
            try {
                URL result = new URL(uri);
                this.setBaseUri(result.toExternalForm());
            }
            catch (MalformedURLException e) {
                try {
                    this.setBaseUri(new File(".").toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e1) {
                    throw new IllegalStateException("The default NaiveUserAgent doesn't know how to resolve the base URL for " + uri, e1);
                }
            }
        }
        try {
            return new URL(uri).toString();
        }
        catch (MalformedURLException e) {
            XRLog.load(Level.FINE, "Could not read " + uri + " as a URL; may be relative. Testing using parent URL " + this._baseUri);
            try {
                URL result = new URL(new URL(this._baseUri), uri);
                String ret = result.toString();
                XRLog.load(Level.FINE, "Was able to read from " + uri + " using parent URL " + this._baseUri);
                return ret;
            }
            catch (MalformedURLException e1) {
                throw new IllegalStateException("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this._baseUri, e1);
            }
        }
    }

    public void setBaseUri(String baseUri) {
        this._baseUri = baseUri;
    }

    @Nonnull
    @CheckReturnValue
    public String getBaseUri() {
        return this._baseUri;
    }
}

