/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.resource;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.resource.AbstractResource;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.swing.MutableFSImage;
import org.xml.sax.InputSource;

@ParametersAreNonnullByDefault
public class ImageResource
extends AbstractResource {
    private final String _imageUri;
    private final FSImage _img;

    public ImageResource(@Nullable String uri, @Nullable FSImage img) {
        super((InputSource)null);
        this._imageUri = uri;
        this._img = img;
    }

    public FSImage getImage() {
        return this._img;
    }

    public boolean isLoaded() {
        return !(this._img instanceof MutableFSImage) || ((MutableFSImage)this._img).isLoaded();
    }

    public String getImageUri() {
        return this._imageUri;
    }

    public boolean hasDimensions(int width, int height) {
        if (this.isLoaded()) {
            FSImage fSImage = this._img;
            if (fSImage instanceof AWTFSImage) {
                AWTFSImage image = (AWTFSImage)fSImage;
                return image.getWidth() == width && image.getHeight() == height;
            }
            return false;
        }
        return false;
    }
}

